/*
 * Decompiled with CFR 0.152.
 */
package lc.recipe;

import java.util.ArrayList;
import java.util.List;
import lc.LCRuntime;
import lc.common.util.game.BlockHelper;
import lc.common.util.game.InventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class DecoratorSetterRecipe
implements IRecipe {
    private final int width = 2;
    private final int height = 2;
    private final Item decorTool;

    public DecoratorSetterRecipe() {
        this.decorTool = LCRuntime.runtime.items().lanteaDecoratorTool.getItem();
    }

    public boolean func_77569_a(InventoryCrafting crafting, World world) {
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                if (!this.checkMatch(crafting, x, y, false) && !this.checkMatch(crafting, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting crafting, int startX, int startY, boolean mirror) {
        ArrayList<ItemStack> shapelessItems = new ArrayList<ItemStack>();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = crafting.func_70463_b(x, y);
                if (stack == null) continue;
                shapelessItems.add(stack);
            }
        }
        return shapelessItems.size() > 0 && this.checkShapelessItems(crafting, shapelessItems);
    }

    public boolean checkShapelessItems(InventoryCrafting crafting, ArrayList<ItemStack> shapelessItems) {
        boolean flag0 = false;
        boolean flag2 = false;
        int p = 0;
        for (ItemStack stack : shapelessItems) {
            if (stack.func_77973_b().equals(this.decorTool)) {
                if (flag0) {
                    flag2 = true;
                    continue;
                }
                flag0 = true;
                continue;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == null) continue;
            ++p;
        }
        return flag0 && (p == 0 || p == 1) && !flag2;
    }

    public ItemStack func_77572_b(InventoryCrafting craft) {
        List<ItemStack> allItems = InventoryHelper.allItems((IInventory)craft);
        ItemStack decorStack = new ItemStack(this.decorTool);
        ItemStack blockStack = null;
        Block block = null;
        for (ItemStack stack : allItems) {
            Block theBlock = Block.func_149634_a((Item)stack.func_77973_b());
            if (theBlock == null || !theBlock.func_149637_q()) continue;
            blockStack = stack;
            block = theBlock;
        }
        if (block != null) {
            String blockName = BlockHelper.saveBlock(block, blockStack.func_77960_j());
            decorStack.field_77990_d = new NBTTagCompound();
            decorStack.field_77990_d.func_74778_a("block-name", blockName);
        }
        return decorStack;
    }

    public int func_77570_a() {
        return 4;
    }

    public ItemStack func_77571_b() {
        return new ItemStack(this.decorTool);
    }
}

