/*
 * Decompiled with CFR 0.152.
 */
package lc.items;

import java.util.List;
import lc.api.components.ComponentType;
import lc.api.defs.Definition;
import lc.api.stargate.IrisType;
import lc.common.base.LCItem;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

@Definition(name="irisUpgrade", type=ComponentType.STARGATE, itemClass=ItemIrisUpgrade.class)
public class ItemIrisUpgrade
extends LCItem {
    private IIcon iconMissing;
    private IIcon iconMechanical;
    private IIcon iconEnergy;

    public ItemIrisUpgrade() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77656_e(21);
        this.setNoRepair();
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < IrisType.values().length; ++i) {
            ItemStack stack = new ItemStack((Item)this, 1);
            this.setType(stack, IrisType.fromOrdinal(i));
            this.setIrisDamage(stack, 0.0);
            par3List.add(stack);
        }
    }

    public void func_94581_a(IIconRegister reg) {
        this.iconMissing = reg.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:missing", new Object[0]));
        this.iconMechanical = reg.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "energy_iris_upgrade"));
        this.iconEnergy = reg.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "iris_upgrade"));
    }

    public IIcon func_77650_f(ItemStack par1ItemStack) {
        IrisType typeof = this.getType(par1ItemStack);
        if (typeof != null) {
            switch (typeof) {
                case ENERGY: {
                    return this.iconEnergy;
                }
                case MECHANICAL: {
                    return this.iconMechanical;
                }
            }
        }
        return this.iconMissing;
    }

    public void acceptDamage(ItemStack stack, double quantity) {
        IrisType typeof = this.getType(stack);
        if (!typeof.isInvulnerable()) {
            this.setIrisDamage(stack, this.getIrisDamage(stack) + quantity);
        }
    }

    public double getMaximumDamage(IrisType typeof) {
        switch (typeof) {
            case MECHANICAL: {
                return 1024.0;
            }
            case ENERGY: {
                return 99999.0;
            }
        }
        return -1.0;
    }

    public IrisType getType(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("type")) {
            stack.field_77990_d.func_74768_a("type", 0);
        }
        return IrisType.fromOrdinal(stack.field_77990_d.func_74762_e("type"));
    }

    public void setType(ItemStack stack, IrisType type) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("type", type.ordinal());
        this.updateDisplay(stack);
    }

    public double getIrisDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("damage")) {
            return 0.0;
        }
        return stack.field_77990_d.func_74769_h("damage");
    }

    public void setIrisDamage(ItemStack stack, double value) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74780_a("damage", value);
        this.updateDisplay(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean wat) {
        double damage = 100.0 * this.getIrisDamage(stack) / this.getMaximumDamage(this.getType(stack));
        list.add(I18n.func_135052_a((String)"lc.interface.iris.type.text", (Object[])new Object[]{I18n.func_135052_a((String)String.format("lc.interface.iris.type.%s.name", this.getType(stack).getName()), (Object[])new Object[0])}));
        list.add(I18n.func_135052_a((String)"lc.interface.iris.damage.text", (Object[])new Object[]{String.format("%.2f%%", damage)}));
    }

    private void updateDisplay(ItemStack stack) {
        double ratio = this.getIrisDamage(stack) / this.getMaximumDamage(this.getType(stack));
        stack.func_77964_b(21 - (int)Math.floor(20.0 * ratio));
    }
}

