/*
 * Decompiled with CFR 0.152.
 */
package lc.gui;

import java.awt.Dimension;
import java.util.HashMap;
import lc.api.stargate.IStargateAccess;
import lc.common.base.ux.IconButton;
import lc.common.base.ux.LCContainerGUI;
import lc.common.base.ux.LCContainerTab;
import lc.common.base.ux.LCTabbedSlot;
import lc.common.base.ux.Popover;
import lc.common.resource.ResourceAccess;
import lc.container.ContainerStargate;
import lc.tiles.TileStargateBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GUIStargate
extends LCContainerGUI {
    private static final HashMap<Integer, LCContainerTab> tabs = new HashMap();

    public GUIStargate(TileStargateBase tile, EntityPlayer player) {
        super(tile, new ContainerStargate(tile, player));
        this.switchTab(0);
    }

    @Override
    protected HashMap<Integer, LCContainerTab> getTabs() {
        return tabs;
    }

    static {
        tabs.put(0, new StargateDefaultTab());
        tabs.put(1, new StargateRedstoneTab());
    }

    public static class StargateRedstoneTab
    extends LCContainerTab {
        @Override
        protected void onTabOpened(LCContainerGUI container) {
            for (Object o : container.field_147002_h.field_75151_b) {
                if (!(o instanceof LCTabbedSlot)) continue;
                ((LCTabbedSlot)((Object)o)).hideSlot();
            }
        }

        @Override
        protected void onTabClosed(LCContainerGUI container) {
        }

        @Override
        protected String getTabName() {
            return I18n.func_135052_a((String)"lc.interface.redstone.name", (Object[])new Object[0]);
        }

        @Override
        protected ResourceLocation getTabIcon() {
            return ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/icons/icon_redstone_${TEX_QUALITY}.png", new Object[0]));
        }

        @Override
        protected Dimension getTabDimensions() {
            return new Dimension(220, 50);
        }

        @Override
        protected void drawBackgroundLayer(LCContainerGUI container, float partialTickCount, int mouseX, int mouseY) {
            container.bindTexture(ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/prefabs/blank_gui_128.png", new Object[0])));
            container.drawTexturedRect(0.0, 0.0, container.getXSize(), container.getYSize());
        }

        @Override
        protected void drawForegroundLayer(LCContainerGUI container, int mouseX, int mouseY) {
            IconButton.drawIcon(Minecraft.func_71410_x(), "icon_iris", 0, 5, 0.5, 1.0f);
            container.setTextColor(0xFFFFFF);
            container.drawString(I18n.func_135052_a((String)"lc.interface.options.iris_mode", (Object[])new Object[0]), 15, 7);
            IconButton.drawButton(Minecraft.func_71410_x(), "icon_rstorchon", 85, 5, mouseX - container.offsetLeft(), mouseY - container.offsetTop(), container.isMouseDown(), 0.5, 1.0f);
            if (IconButton.buttonHovered(85, 5, mouseX - container.offsetLeft(), mouseY - container.offsetTop(), 0.5)) {
                container.drawTooltip(I18n.func_135052_a((String)"lc.interface.redstone.active_high", (Object[])new Object[0]), mouseX - container.offsetLeft(), mouseY - container.offsetTop());
            }
        }

        @Override
        protected void mouseClicked(LCContainerGUI container, int x, int y, int mouseButton) {
        }

        @Override
        protected void mouseMovedOrUp(LCContainerGUI container, int x, int y, int mouseButton) {
        }

        @Override
        protected void keyTyped(LCContainerGUI container, char c, int key) {
        }

        @Override
        protected void update(LCContainerGUI container) {
        }
    }

    public static class StargateDefaultTab
    extends LCContainerTab {
        @Override
        protected void onTabOpened(LCContainerGUI container) {
            for (Object o : container.field_147002_h.field_75151_b) {
                if (!(o instanceof LCTabbedSlot)) continue;
                ((LCTabbedSlot)((Object)o)).showSlot();
            }
        }

        @Override
        protected void onTabClosed(LCContainerGUI container) {
        }

        @Override
        protected String getTabName() {
            return I18n.func_135052_a((String)"lc.interface.stargate.name", (Object[])new Object[0]);
        }

        @Override
        protected ResourceLocation getTabIcon() {
            return ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/icons/stargate_${TEX_QUALITY}.png", new Object[0]));
        }

        @Override
        protected Dimension getTabDimensions() {
            return new Dimension(256, 208);
        }

        @Override
        protected void drawBackgroundLayer(LCContainerGUI container, float partialTickCount, int mouseX, int mouseY) {
            container.bindTexture(ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/prefabs/sg_gui_${TEX_QUALITY}.png", new Object[0])), 256, 256);
            container.drawTexturedRect(0.0, 0.0, container.getXSize(), container.getYSize(), 0.0, 0.0);
        }

        @Override
        protected void drawForegroundLayer(LCContainerGUI container, int mouseX, int mouseY) {
            IStargateAccess stargate = (IStargateAccess)container.getTile();
            String address = stargate.getStargateAddress().getAddressString();
            container.drawAddressString(128, 56, address, 9, "-", "-");
            container.drawFramedSymbols(128, 8, stargate.getStargateType(), address.toCharArray());
            IconButton.drawButton(Minecraft.func_71410_x(), "copy", 240, 54, mouseX - container.offsetLeft(), mouseY - container.offsetTop(), container.isMouseDown(), 0.75, 1.0f);
            if (IconButton.buttonHovered(240, 54, mouseX - container.offsetLeft(), mouseY - container.offsetTop(), 1.0)) {
                container.drawTooltip(I18n.func_135052_a((String)"lc.interface.clipboard.write", (Object[])new Object[0]), mouseX - container.offsetLeft(), mouseY - container.offsetTop());
            }
        }

        @Override
        protected void mouseClicked(LCContainerGUI container, int x, int y, int mouseButton) {
        }

        @Override
        protected void mouseMovedOrUp(LCContainerGUI container, int x, int y, int mouseButton) {
            if ((mouseButton == 0 || mouseButton == 1) && IconButton.buttonDepressed(240, 54, x - container.offsetLeft(), y - container.offsetTop(), container.isMouseDown(), 1.0)) {
                IStargateAccess stargate = (IStargateAccess)container.getTile();
                String address = stargate.getStargateAddress().getAddressString();
                boolean result = container.putTextOnClipboard(address);
                if (result) {
                    container.pushPopover(new Popover(I18n.func_135052_a((String)"lc.interface.clipboard.write_ok", (Object[])new Object[0]), 120));
                } else {
                    container.pushPopover(new Popover(I18n.func_135052_a((String)"lc.interface.clipboard.write_fail", (Object[])new Object[0]), 120));
                }
            }
        }

        @Override
        protected void keyTyped(LCContainerGUI container, char c, int key) {
        }

        @Override
        protected void update(LCContainerGUI container) {
        }
    }
}

