/*
 * Decompiled with CFR 0.152.
 */
package lc.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import lc.common.LCLog;
import lc.common.resource.ResourceAccess;
import lc.common.stargate.StargateCharsetHelper;
import lc.common.util.ScanningHelper;
import lc.tiles.TileStargateBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIPortableDHD
extends GuiScreen {
    final int dhdWidth = 260;
    final int dhdHeight = 180;
    final double dhdRadius1 = 26.0;
    final double dhdRadius2 = 71.5;
    final double dhdRadius3 = 117.0;
    private int dhdTop;
    private int dhdCentreX;
    private int dhdCentreY;
    private int ticks = 0;
    private ResourceLocation dhdLayer;
    private ResourceLocation dhdButtonLayer;
    private double offX;
    private double offY;
    double uscale;
    double vscale;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    private final EntityPlayer player;
    private TileStargateBase foundTile;

    public GUIPortableDHD(EntityPlayer player) {
        this.player = player;
        this.dhdLayer = ResourceAccess.getNamedResource("textures/gui/dhd/dhd_gui.png");
        this.dhdButtonLayer = ResourceAccess.getNamedResource("textures/gui/dhd/dhd_centre.png");
        this.dhdCentreX = 130;
        this.dhdCentreY = 90;
        this.dhdTop = 48;
    }

    public TileStargateBase getTile() {
        if (this.foundTile != null) {
            return this.foundTile;
        }
        TileEntity tile = ScanningHelper.findNearestTileEntityOf(this.player.field_70170_p, TileStargateBase.class, (int)Math.round(this.player.field_70165_t), (int)Math.round(this.player.field_70163_u), (int)Math.round(this.player.field_70161_v), AxisAlignedBB.func_72330_a((double)-5.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)5.0));
        if (tile != null && tile instanceof TileStargateBase) {
            this.foundTile = (TileStargateBase)tile;
            return this.foundTile;
        }
        return null;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTickCount) {
        TileStargateBase near = this.getTile();
        if (near == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.offX = this.field_146294_l / 2 - this.dhdCentreX;
        this.offY = this.field_146295_m / 2 - this.dhdCentreY;
        if (near != null) {
            this.drawBackgroundLayer(partialTickCount, mouseX, mouseY);
            this.drawForegroundLayer(mouseX, mouseY);
        }
    }

    protected void drawBackgroundLayer(float partialTickCount, int mouseX, int mouseY) {
        this.bindTexture(this.dhdLayer);
        this.drawTexturedRect(this.offX, this.offY + (double)this.dhdTop, 260.0, 180.0);
        this.bindTexture(this.dhdButtonLayer, 128, 64);
        GL11.glEnable((int)3042);
        TileStargateBase stargate = this.getTile();
        if (stargate.hasConnectionState()) {
            this.setColor(1.0, 0.5, 0.0);
        } else {
            this.setColor(0.5, 0.25, 0.0);
        }
        double rx = 24.375;
        double ry = 24.971098265895954;
        Tessellator.field_78398_a.func_78383_c();
        this.drawTexturedRect(this.offX + (double)this.dhdCentreX - rx, this.offY + (double)this.dhdTop + (double)this.dhdCentreY - ry + 8.0, 2.0 * rx, 1.5 * ry, 64.0, 0.0, 64.0, 48.0);
        this.resetColor();
        if (stargate.hasConnectionState()) {
            GL11.glBlendFunc((int)1, (int)1);
            double d = 5.0;
            this.drawTexturedRect(this.offX + (double)this.dhdCentreX - rx - d, this.offY + (double)this.dhdTop + (double)this.dhdCentreY - ry - d + 8.0, 2.0 * (rx + d), ry + d, 0.0, 0.0, 64.0, 32.0);
            this.drawTexturedRect(this.offX + (double)this.dhdCentreX - rx - d, this.offY + (double)this.dhdTop + (double)this.dhdCentreY + 8.0, 2.0 * (rx + d), 0.5 * ry + d, 0.0, 32.0, 64.0, 32.0);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    protected void drawForegroundLayer(int mouseX, int mouseY) {
        TileStargateBase dhd = this.getTile();
        this.drawAddressString((int)(this.offX + (double)this.dhdCentreX), (int)(this.offY + 48.0), dhd.getActivatedGlyphs(), 9, " ", this.ticks > 10 ? "_" : " ");
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        int i;
        if (mouseButton == 0 && (i = this.findDHDButton((int)((double)x - this.offX), (int)((double)y - this.offY))) >= 0) {
            LCLog.debug("dhdClickGet: %s", i);
            this.dhdButtonPressed(this.getTile(), i);
            return;
        }
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        } else if (key == 14 || key == 211) {
            this.backspace(this.getTile());
        } else if (key == 28 || key == 156) {
            this.orangeButtonPressed(this.getTile());
        } else {
            String C = String.valueOf(c).toUpperCase();
            if (StargateCharsetHelper.singleton().isLegal(C)) {
                this.write(this.getTile(), C.charAt(0));
            }
        }
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && key == 47) {
            try {
                String data = this.getTextFromClipboard();
                for (char c1 : data.toCharArray()) {
                    if (!StargateCharsetHelper.singleton().isLegal(c1)) continue;
                    this.write(this.getTile(), c1);
                }
            }
            catch (Exception e) {
                LCLog.warn("Can't read from clipboard.", e);
            }
        }
    }

    public void func_73876_c() {
        this.ticks = (this.ticks + 1) % 20;
    }

    private int findDHDButton(int mx, int my) {
        double x = -(mx - this.dhdCentreX);
        double y = -(my - this.dhdCentreY - this.dhdTop) * 260 / 180;
        double r = Math.hypot(x, y);
        LCLog.debug("dhdClick: " + x + ", " + y);
        if (r > 117.0) {
            return -1;
        }
        if (r <= 26.0) {
            return 0;
        }
        double a = Math.toDegrees(Math.atan2(y, x));
        if (a < 0.0) {
            a += 360.0;
        }
        int i0 = r <= 71.5 ? 20 : 1;
        int i = i0 + (int)Math.floor(a * 19.0 / 360.0);
        return i;
    }

    private void dhdButtonPressed(TileStargateBase tile, int i) {
        if (i == 0) {
            this.orangeButtonPressed(tile);
        } else if (i > 38) {
            this.backspace(tile);
        } else {
            this.write(tile, StargateCharsetHelper.singleton().index(i - 1));
        }
    }

    private void orangeButtonPressed(TileStargateBase tile) {
        if (!tile.hasConnectionState()) {
            tile.engageStargate();
        } else {
            tile.disengageStargate();
        }
    }

    private void backspace(TileStargateBase tile) {
        tile.deactivateChevron();
    }

    private void write(TileStargateBase tile, char c) {
        tile.selectGlyph(c);
        tile.activateChevron();
    }

    public String getTextFromClipboard() {
        try {
            Clipboard source = Toolkit.getDefaultToolkit().getSystemClipboard();
            return (String)source.getData(DataFlavor.stringFlavor);
        }
        catch (Throwable t) {
            LCLog.warn("Can't read from clipboard.", t);
            return null;
        }
    }

    public void bindTexture(ResourceLocation rsrc) {
        this.bindTexture(rsrc, 1, 1);
    }

    public void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        this.field_146297_k.func_110434_K().func_110577_a(rsrc);
        this.uscale = 1.0 / (double)usize;
        this.vscale = 1.0 / (double)vsize;
    }

    public void drawTexturedRect(double x, double y, double w, double h) {
        this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.uscale, v * this.vscale, us * this.uscale, vs * this.vscale);
    }

    public void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(this.red, this.green, this.blue);
        tess.func_78374_a(x, y + h, (double)this.field_73735_i, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)this.field_73735_i, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)this.field_73735_i, u + us, v);
        tess.func_78374_a(x, y, (double)this.field_73735_i, u, v);
        tess.func_78381_a();
    }

    public void drawGradientRectUV(int x, int y, int x1, int y1, int c0, int c1) {
        float f = (float)(c0 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c0 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c0 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c0 & 0xFF) / 255.0f;
        float f4 = (float)(c1 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(c1 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(c1 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(c1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)x1, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)x, (double)y1, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x1, (double)y1, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void drawAddressString(int x, int y, String address, int len, String padding, String caret) {
        StringBuilder result = new StringBuilder();
        result.append(address);
        if (len != result.length() && caret != null) {
            result.append(caret);
        }
        while (len > result.length()) {
            result.append(padding);
        }
        this.func_73732_a(this.field_146289_q, result.toString(), x, y, 0xFFFFFF);
    }

    public void setColor(int hex) {
        this.setColor((double)(hex >> 16) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public void setColor(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }
}

