/*
 * Decompiled with CFR 0.152.
 */
package lc.gui;

import java.awt.Dimension;
import java.util.HashMap;
import lc.common.LCLog;
import lc.common.base.ux.LCContainerGUI;
import lc.common.base.ux.LCContainerTab;
import lc.common.resource.ResourceAccess;
import lc.common.stargate.StargateCharsetHelper;
import lc.common.util.data.PrimitiveHelper;
import lc.container.ContainerDHD;
import lc.tiles.TileDHD;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIDHD
extends LCContainerGUI {
    private static final HashMap<Integer, LCContainerTab> tabs = new HashMap();

    public GUIDHD(TileDHD tile, EntityPlayer player) {
        super(tile, new ContainerDHD(tile, player));
        this.switchTab(0);
    }

    @Override
    protected HashMap<Integer, LCContainerTab> getTabs() {
        return tabs;
    }

    static {
        tabs.put(0, new DHDDefaultTab());
    }

    private static class DHDDefaultTab
    extends LCContainerTab {
        final int dhdWidth = 260;
        final int dhdHeight = 180;
        final double dhdRadius1 = 26.0;
        final double dhdRadius2 = 71.5;
        final double dhdRadius3 = 117.0;
        private int dhdTop;
        private int dhdCentreX;
        private int dhdCentreY;
        private int ticks = 0;
        private ResourceLocation dhdLayer = ResourceAccess.getNamedResource("textures/gui/dhd/dhd_gui.png");
        private ResourceLocation dhdButtonLayer = ResourceAccess.getNamedResource("textures/gui/dhd/dhd_centre.png");

        @Override
        protected void onTabOpened(LCContainerGUI container) {
            this.dhdCentreX = 130;
            this.dhdCentreY = 90;
            this.dhdTop = 48;
        }

        @Override
        protected void onTabClosed(LCContainerGUI container) {
        }

        @Override
        protected String getTabName() {
            return I18n.func_135052_a((String)"lc.interface.dhd.name", (Object[])new Object[0]);
        }

        @Override
        protected ResourceLocation getTabIcon() {
            return ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/icons/stargate_${TEX_QUALITY}.png", new Object[0]));
        }

        @Override
        protected Dimension getTabDimensions() {
            return new Dimension(260, 180 + this.dhdTop);
        }

        @Override
        protected void drawBackgroundLayer(LCContainerGUI container, float partialTickCount, int mouseX, int mouseY) {
            container.bindTexture(this.dhdLayer);
            container.drawTexturedRect(0.0, this.dhdTop, 260.0, 180.0);
            container.bindTexture(this.dhdButtonLayer, 128, 64);
            GL11.glEnable((int)3042);
            TileDHD dhd = (TileDHD)container.getTile();
            if (dhd.clientAskConnectionOpen()) {
                container.setColor(1.0, 0.5, 0.0);
            } else {
                container.setColor(0.5, 0.25, 0.0);
            }
            double rx = 24.375;
            double ry = 24.971098265895954;
            Tessellator.field_78398_a.func_78383_c();
            container.drawTexturedRect((double)this.dhdCentreX - rx, (double)(this.dhdTop + this.dhdCentreY) - ry + 8.0, 2.0 * rx, 1.5 * ry, 64.0, 0.0, 64.0, 48.0);
            container.resetColor();
            if (dhd.clientAskConnectionOpen()) {
                GL11.glBlendFunc((int)1, (int)1);
                double d = 5.0;
                container.drawTexturedRect((double)this.dhdCentreX - rx - d, (double)(this.dhdTop + this.dhdCentreY) - ry - d + 8.0, 2.0 * (rx + d), ry + d, 0.0, 0.0, 64.0, 32.0);
                container.drawTexturedRect((double)this.dhdCentreX - rx - d, (double)(this.dhdTop + this.dhdCentreY) + 8.0, 2.0 * (rx + d), 0.5 * ry + d, 0.0, 32.0, 64.0, 32.0);
                GL11.glBlendFunc((int)770, (int)771);
            }
        }

        @Override
        protected void drawForegroundLayer(LCContainerGUI container, int mouseX, int mouseY) {
            TileDHD dhd = (TileDHD)container.getTile();
            char[] glyphs = PrimitiveHelper.unbox(dhd.clientAskEngagedGlpyhs());
            container.drawFramedSymbols(this.dhdCentreX, 0, dhd.getDHDType(), glyphs);
            container.drawAddressString(this.dhdCentreX, 48, PrimitiveHelper.flatten(glyphs), 9, " ", this.ticks > 10 ? "_" : " ");
        }

        @Override
        protected void mouseClicked(LCContainerGUI container, int x, int y, int mouseButton) {
            int i;
            if (mouseButton == 0 && (i = this.findDHDButton(x - container.offsetLeft(), y - container.offsetTop())) >= 0) {
                this.dhdButtonPressed((TileDHD)container.getTile(), i);
                return;
            }
        }

        @Override
        protected void mouseMovedOrUp(LCContainerGUI container, int x, int y, int mouseButton) {
        }

        @Override
        protected void keyTyped(LCContainerGUI container, char c, int key) {
            if (key == 1) {
                container.field_146297_k.func_147108_a((GuiScreen)null);
                container.field_146297_k.func_71381_h();
            } else if (key == 14 || key == 211) {
                this.backspace((TileDHD)container.getTile());
            } else if (key == 28 || key == 156) {
                this.orangeButtonPressed((TileDHD)container.getTile());
            } else {
                String C = String.valueOf(c).toUpperCase();
                if (StargateCharsetHelper.singleton().isLegal(C)) {
                    this.write((TileDHD)container.getTile(), C.charAt(0));
                }
            }
            if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && key == 47) {
                try {
                    String data = container.getTextFromClipboard();
                    for (char c1 : data.toCharArray()) {
                        if (!StargateCharsetHelper.singleton().isLegal(c1)) continue;
                        this.write((TileDHD)container.getTile(), c1);
                    }
                }
                catch (Exception e) {
                    LCLog.warn("Can't read from clipboard.", e);
                }
            }
        }

        @Override
        protected void update(LCContainerGUI container) {
            this.ticks = (this.ticks + 1) % 20;
        }

        private int findDHDButton(int mx, int my) {
            double x = -(mx - this.dhdCentreX);
            double y = -(my - this.dhdCentreY - this.dhdTop) * 260 / 180;
            double r = Math.hypot(x, y);
            LCLog.debug("dhdClick: " + x + ", " + y);
            if (r > 117.0) {
                return -1;
            }
            if (r <= 26.0) {
                return 0;
            }
            double a = Math.toDegrees(Math.atan2(y, x));
            if (a < 0.0) {
                a += 360.0;
            }
            int i0 = r <= 71.5 ? 20 : 1;
            int i = i0 + (int)Math.floor(a * 19.0 / 360.0);
            return i;
        }

        private void dhdButtonPressed(TileDHD tile, int i) {
            if (i == 0) {
                this.orangeButtonPressed(tile);
            } else if (i > 38) {
                this.backspace(tile);
            } else {
                this.write(tile, StargateCharsetHelper.singleton().index(i - 1));
            }
        }

        private void orangeButtonPressed(TileDHD tile) {
            tile.clientDoPressedButton(2, '\u0000');
        }

        private void backspace(TileDHD tile) {
            tile.clientDoPressedButton(1, '\u0000');
        }

        private void write(TileDHD tile, char c) {
            tile.clientDoPressedButton(0, c);
        }
    }
}

