/*
 * Decompiled with CFR 0.152.
 */
package lc.generation;

import java.util.List;
import java.util.Random;
import lc.api.rendering.IBlockSkinnable;
import lc.common.LCLog;
import lc.common.base.LCBlock;
import lc.common.base.LCTile;
import lc.common.base.generation.scattered.LCScatteredFeature;
import lc.common.base.generation.scattered.LCScatteredFeatureStart;
import lc.common.base.multiblock.StructureConfiguration;
import lc.common.util.game.BlockFilter;
import lc.common.util.math.Matrix3;
import lc.common.util.math.Orientations;
import lc.common.util.math.Vector3;
import lc.common.util.math.VectorAABB;
import lc.tiles.TileStargateBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class SurfaceStargate
extends LCScatteredFeatureStart {
    public SurfaceStargate() {
    }

    public SurfaceStargate(World world, Random rand, int x, int y) {
        super(world, rand, x, y);
    }

    @Override
    protected void addComponents(World world, Random rng, int cx, int cz) {
        this.field_75075_a.add(new SurfaceStargateFeature(rng, cx, cz));
    }

    public static class SurfaceStargateFeature
    extends LCScatteredFeature {
        private Orientations rotation;

        public SurfaceStargateFeature() {
        }

        public SurfaceStargateFeature(Random rng, int x, int z) {
            super(rng, x + rng.nextInt(7), 0, z + rng.nextInt(7), 9, 64, 9);
            this.rotation = Orientations.randomCardinal(rng);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tag) {
            super.func_143012_a(tag);
            tag.func_74768_a("Rotation", this.rotation.ordinal());
        }

        @Override
        protected void func_143011_b(NBTTagCompound tag) {
            super.func_143011_b(tag);
            if (tag.func_74764_b("Rotation")) {
                this.rotation = Orientations.values()[tag.func_74762_e("Rotation")];
            }
        }

        @Override
        public boolean func_74875_a(World w, Random r, StructureBoundingBox bb) {
            this.recalcHeightOffsets(w, bb, 1);
            Vector3 v0 = new Vector3(0.0, -4.0, 0.0);
            Vector3 v1 = new Vector3(this.scatteredFeatureSizeX - 1, 0.0, this.scatteredFeatureSizeZ - 1);
            Vector3 vMin = Vector3.zero;
            Vector3 vMax = new Vector3(this.scatteredFeatureSizeX - 1, this.scatteredFeatureSizeY - 1, this.scatteredFeatureSizeZ - 1);
            this.fill(w, bb, vMin, vMax, Blocks.field_150350_a);
            this.fill(w, bb, v0, v1, Blocks.field_150322_A);
            StructureConfiguration config = TileStargateBase.milkyStructure;
            Vector3 center = new Vector3(Math.floor(this.scatteredFeatureSizeX / 2), 0.0, Math.floor(this.scatteredFeatureSizeZ / 2));
            this.paintStructure(config, w, bb, center.fx(), center.fy(), center.fz(), this.rotation, Blocks.field_150322_A, 0);
            return true;
        }

        private void paintStructure(StructureConfiguration config, World w, StructureBoundingBox bb, int x, int y, int z, Orientations orientation, Block baseBlock, int baseMeta) {
            BlockFilter[] mappings = config.getBlockMappings();
            Matrix3 rotation = orientation.rotation();
            Vector3 origin = new Vector3(x, y, z).sub(rotation.mul(config.getStructureCenter()));
            VectorAABB box = VectorAABB.boxOf(origin, config.getStructureDimensions());
            List<Vector3> elems = box.contents();
            for (Vector3 mapping : elems) {
                Vector3 tile = origin.add(rotation.mul(mapping));
                try {
                    int cell = config.getStructureLayout()[mapping.fx()][mapping.fy()][mapping.fz()];
                    BlockFilter filter = mappings[cell];
                    Block what = filter.getBlock();
                    int metadata = Math.max(0, filter.getMetadata());
                    this.fill(w, bb, tile, tile, what, metadata);
                    if (!(what instanceof LCBlock)) continue;
                    int tx = this.func_74865_a(tile.fx(), tile.fz());
                    int tz = this.func_74873_b(tile.fx(), tile.fz());
                    LCTile te = (LCTile)w.func_147438_o(tx, this.func_74862_a(tile.fy()), tz);
                    if (te != null && ((LCBlock)what).canRotate()) {
                        te.setRotation(orientation.forge());
                    }
                    if (tile.fy() != y || !(te instanceof IBlockSkinnable)) continue;
                    IBlockSkinnable skinnable = (IBlockSkinnable)((Object)te);
                    skinnable.setSkinBlock(baseBlock, baseMeta);
                }
                catch (IndexOutOfBoundsException bounds) {
                    LCLog.fatal("Access out of bounds: " + bounds.getMessage() + ": " + String.format("%s %s %s", mapping.fx(), mapping.fy(), mapping.fz()));
                }
            }
        }
    }
}

