/*
 * Decompiled with CFR 0.152.
 */
package lc.dimensions.any;

import java.util.Random;
import lc.api.defs.IDefinitionReference;
import lc.api.world.OreType;
import lc.common.LCLog;
import lc.common.base.generation.LCChunkData;
import lc.common.base.generation.decoration.LCChunkDecoration;
import lc.common.util.game.DataResolver;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class LCOreDecorator
extends LCChunkDecoration {
    protected final OreType type;
    protected final IDefinitionReference blockType;
    private static int genIsolatedOdds = 8;
    private static int maxIsolatedNodes = 4;

    public LCOreDecorator(OreType type, IDefinitionReference blockType) {
        this.type = type;
        this.blockType = blockType;
    }

    @Override
    public String getName() {
        return "LCOreDecorator{" + this.type.name() + "}";
    }

    @Override
    public void decorateChunk(Random random, World world, Chunk chunk, LCChunkData data) {
        Block blockStone = (Block)Block.field_149771_c.func_82594_a("stone");
        ItemBlock paintItem = (ItemBlock)DataResolver.resolve(this.blockType).func_77973_b();
        Block paintBlock = paintItem.field_150939_a;
        if (!this.odds(random, genIsolatedOdds)) {
            // empty if block
        }
        int n = random.nextInt(maxIsolatedNodes) + 1;
        for (int i = 0; i < n; ++i) {
            int z;
            int y;
            int x = random.nextInt(16);
            if (!this.getBlock(chunk, x, y = random.nextInt(64), z = random.nextInt(16)).equals(blockStone)) continue;
            this.generateNode(chunk, world, random, paintBlock, this.type, x, y, z, 6);
        }
    }

    private boolean odds(Random random, int n) {
        return random.nextInt(n) == 0;
    }

    private Block getBlock(Chunk chunk, int x, int y, int z) {
        return chunk.func_150810_a(x, y, z);
    }

    private void setBlock(Chunk chunk, int x, int y, int z, Block block, int metadata) {
        chunk.func_150807_a(x, y, z, block, metadata);
    }

    void generateNode(Chunk chunk, World world, Random random, Block block, OreType type, int cx, int cy, int cz, int density) {
        Block blockStone = (Block)Block.field_149771_c.func_82594_a("stone");
        int tries = 0;
        block8: while (density > 0) {
            int tx = cx;
            int ty = cy;
            int tz = cz;
            do {
                int trans = random.nextInt(6);
                switch (trans) {
                    case 0: {
                        ++tx;
                        break;
                    }
                    case 1: {
                        --tx;
                        break;
                    }
                    case 2: {
                        ++ty;
                        break;
                    }
                    case 3: {
                        --ty;
                        break;
                    }
                    case 4: {
                        ++tz;
                        break;
                    }
                    case 5: {
                        --tz;
                    }
                }
                if (tx > 15 || tz > 15 || 0 > tx || 0 > ty || 0 > tz) continue block8;
            } while (this.getBlock(chunk, tx, ty, tz).equals(block));
            if (!this.getBlock(chunk, tx, ty, tz).equals(blockStone)) break;
            if (this.getBlock(chunk, tx, ty, tz).equals(blockStone)) {
                this.setBlock(chunk, tx, ty, tz, block, type.ordinal());
                --density;
                LCLog.debug(new Object[]{"Placed %s at %s %s %s", type, 16 * chunk.field_76635_g + tx, ty, 16 * chunk.field_76647_h + tz});
                tries = 0;
                continue;
            }
            if (tries++ <= 5) continue;
            break;
        }
    }
}

