/*
 * Decompiled with CFR 0.152.
 */
package lc.digital.vm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lc.digital.vm.IHardware;
import lc.digital.vm.kahlua.LuaMachine;
import lc.digital.vm.kahlua.LuaMachineException;

public class Device {
    private LuaMachine emulator = new LuaMachine();
    private HashMap<Integer, IHardware> hardware = new HashMap();

    public void addHardware(Integer spDevSlot, IHardware device) {
        this.hardware.put(spDevSlot, device);
    }

    public void init() {
        try {
            this.emulator.init();
        }
        catch (LuaMachineException luaMachineException) {
            // empty catch block
        }
    }

    public void advance() {
        try {
            this.emulator.advance();
        }
        catch (LuaMachineException luaMachineException) {
            // empty catch block
        }
    }

    public boolean modified() {
        for (Map.Entry<Integer, IHardware> dev : this.hardware.entrySet()) {
            if (!dev.getValue().modified()) continue;
            return true;
        }
        return false;
    }

    public void serialize(DataOutputStream out) throws IOException {
        for (Map.Entry<Integer, IHardware> dev : this.hardware.entrySet()) {
            if (!dev.getValue().modified()) continue;
            out.writeInt(dev.getKey());
            dev.getValue().serialize(out);
        }
    }

    public void unserialize(DataInputStream in) throws IOException {
        while (in.available() != 0) {
            int slot = in.readInt();
            this.hardware.get(slot).unserialize(in);
        }
    }
}

