/*
 * Decompiled with CFR 0.152.
 */
package lc.digital.network;

import lc.api.components.DriverMap;
import lc.common.impl.drivers.LanteaCraftDriverManager;
import lc.digital.network.INetDevice;
import lc.digital.network.INetwork;
import lc.digital.network.NetDevicePosition;
import lc.digital.vm.IDeviceAccess;
import lc.digital.vm.peripheral.ILCPeripheral;
import net.minecraft.tileentity.TileEntity;

public class PeripheralToNetworkWrapper
implements INetDevice,
IDeviceAccess {
    private TileEntity tile;
    private ILCPeripheral peripheral;
    private INetwork network;

    public PeripheralToNetworkWrapper(TileEntity tile) {
        Object mpObject = DriverMap.LANTEACRAFT.managerObject;
        LanteaCraftDriverManager dm = (LanteaCraftDriverManager)mpObject;
        this.tile = tile;
        this.peripheral = dm.getPeripheral(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    @Override
    public NetDevicePosition position() {
        return new NetDevicePosition(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
    }

    @Override
    public void setNetwork(INetwork network) {
        if (this.network != null) {
            this.peripheral.onLCPDisconnect(this);
        }
        this.network = network;
        if (this.network != null) {
            this.peripheral.onLCPConnect(this);
        }
    }

    @Override
    public void signal(ILCPeripheral peripheral, String label, Object[] data) {
        this.network.sendEvent(this, label, data);
    }

    @Override
    public void receiveEvent(INetDevice addresser, String event, Object[] data) {
    }
}

