/*
 * Decompiled with CFR 0.152.
 */
package lc.digital.network;

import java.util.HashMap;
import lc.digital.network.INetDevice;
import lc.digital.network.INetwork;
import lc.digital.network.NetDevicePosition;

public class EthernetNetwork
implements INetwork {
    private HashMap<NetDevicePosition, INetDevice> devices;

    public boolean addDevice(INetDevice device) {
        if (this.devices.containsKey(device.position())) {
            return false;
        }
        if (this.devices.containsValue(device)) {
            return false;
        }
        this.devices.put(device.position(), device);
        return true;
    }

    public void removeDevice(INetDevice device) {
        this.devices.remove(device.position());
    }

    public void mergeNetwork(EthernetNetwork that) {
        for (INetDevice device : that.devices.values()) {
            that.removeDevice(device);
            this.addDevice(device);
        }
    }

    @Override
    public void sendEvent(INetDevice device, String event, Object[] data) {
        if (!this.devices.containsValue(device)) {
            return;
        }
        for (INetDevice d : this.devices.values()) {
            if (d.equals(device)) continue;
            d.receiveEvent(device, event, data);
        }
    }
}

