/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod.compiler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lc.common.LCLog;
import lc.coremod.ASMAssist;
import lc.coremod.compiler.ICompilerFeature;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class HintInjectionCompiler
implements ICompilerFeature {
    @Override
    public byte[] compile(String name, String transformedName, byte[] basicClass) {
        if (!name.startsWith("lc.")) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        List fields = classNode.fields;
        if (fields == null || fields.size() == 0) {
            return basicClass;
        }
        HashMap<String, String> fieldToClazzMap = new HashMap<String, String>();
        for (FieldNode field : fields) {
            String className;
            AnnotationNode hintNode = ASMAssist.findAnnotation(field, "Llc/api/defs/HintProvider;");
            if (hintNode == null) continue;
            Side theSide = FMLCommonHandler.instance().getSide();
            if (theSide == Side.CLIENT) {
                className = (String)ASMAssist.findValue(hintNode, "clientClass");
                if (className == null) continue;
                fieldToClazzMap.put(field.name, className.replace(".", "/"));
                continue;
            }
            className = (String)ASMAssist.findValue(hintNode, "serverClass");
            if (className == null) continue;
            fieldToClazzMap.put(field.name, className.replace(".", "/"));
        }
        if (fieldToClazzMap.size() != 0) {
            LCLog.debug("Adding %s hint field initializer mappings.", fieldToClazzMap.size());
            Iterator methods = classNode.methods.iterator();
            MethodNode initMethod = null;
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                if (!method.name.equals("<init>")) continue;
                initMethod = method;
                break;
            }
            InsnNode lastInsn = null;
            if (initMethod == null) {
                initMethod = new MethodNode(1, "<init>", "()V", "", null);
                lastInsn = new InsnNode(177);
                initMethod.instructions.add((AbstractInsnNode)lastInsn);
            } else {
                for (AbstractInsnNode node : initMethod.instructions) {
                    if (node.getOpcode() != 177) continue;
                    lastInsn = node;
                }
            }
            for (Map.Entry mapping : fieldToClazzMap.entrySet()) {
                LCLog.debug("Adding mapping for hint %s to class initializer %s.", mapping.getKey(), mapping.getValue());
                initMethod.instructions.insertBefore((AbstractInsnNode)lastInsn, (AbstractInsnNode)new VarInsnNode(25, 0));
                initMethod.instructions.insertBefore((AbstractInsnNode)lastInsn, (AbstractInsnNode)new TypeInsnNode(187, (String)mapping.getValue()));
                initMethod.instructions.insertBefore((AbstractInsnNode)lastInsn, (AbstractInsnNode)new InsnNode(89));
                initMethod.instructions.insertBefore((AbstractInsnNode)lastInsn, (AbstractInsnNode)new MethodInsnNode(183, (String)mapping.getValue(), "<init>", "()V", false));
                initMethod.instructions.insertBefore((AbstractInsnNode)lastInsn, (AbstractInsnNode)new FieldInsnNode(181, name.replace(".", "/"), (String)mapping.getKey(), "Llc/common/IHintProvider;"));
            }
            if (initMethod.maxStack < fieldToClazzMap.size() * 4) {
                initMethod.maxStack += fieldToClazzMap.size() * 4;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

