/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lc.api.components.DriverMap;
import lc.api.components.IntegrationType;
import lc.common.LCLog;
import lc.coremod.ASMAssist;
import lc.coremod.LCCompilerException;
import lc.coremod.LCCoreTransformer;
import lc.coremod.compiler.ClassMerger;
import lc.coremod.compiler.ICompilerFeature;
import lc.coremod.compiler.InterfaceInspector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class DriverBindingCompiler
implements ICompilerFeature {
    @Override
    public byte[] compile(String name, String transformedName, byte[] basicClass) {
        if (!name.startsWith("lc.")) {
            return basicClass;
        }
        ClassNode sourceNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)sourceNode, 0);
        List annotations = sourceNode.visibleAnnotations;
        if (annotations == null) {
            return basicClass;
        }
        AnnotationNode providerNode = ASMAssist.findAnnotation(sourceNode, "Llc/api/jit/DeviceDrivers$DriverProvider;");
        if (providerNode != null) {
            LCLog.debug("Found definition driver class %s.", name);
            LCCoreTransformer.$.classCache.forceCache(name, (byte[])basicClass.clone());
            return basicClass;
        }
        AnnotationNode candidateNode = ASMAssist.findAnnotation(sourceNode, "Llc/api/jit/DeviceDrivers$DriverCandidate;");
        if (candidateNode == null) {
            return basicClass;
        }
        ArrayList<IntegrationType> types = new ArrayList<IntegrationType>();
        HashMap<String, String> events = new HashMap<String, String>();
        ArrayList typeList = (ArrayList)ASMAssist.findValue(candidateNode, "types");
        for (Object typeName : typeList) {
            if (!(typeName instanceof String[])) continue;
            String[] params = (String[])typeName;
            for (int q = 1; q < params.length; q += 2) {
                IntegrationType type = IntegrationType.valueOf(params[q]);
                if (types.contains((Object)type)) continue;
                types.add(type);
            }
        }
        for (IntegrationType type : types) {
            LCLog.debug(new Object[]{"Adding drivers for type %s on class %s.", type, name});
            for (DriverMap mapping : DriverMap.mapOf(type)) {
                LCCompilerException[] errors;
                LCLog.debug(new Object[]{"Binding mapping %s (mod %s)", mapping, mapping.modName});
                byte[] driverSrc = LCCoreTransformer.$.classCache.getCached(mapping.className);
                if (driverSrc == null) {
                    LCLog.warn(new Object[]{"Can't find class %s for driver %s, skipping...", mapping.className, mapping});
                    continue;
                }
                try {
                    mapping.trySpinUpDriver();
                }
                catch (Exception failure) {
                    LCLog.warn(new Object[]{"Failed to spin up driver manager class %s for driver %s. Problems may occur.", mapping.managerClassName, mapping});
                }
                ClassNode driverClass = new ClassNode();
                ClassReader reader = new ClassReader(driverSrc);
                reader.accept((ClassVisitor)driverClass, 0);
                boolean acceptImport = true;
                if (driverClass.interfaces != null && driverClass.interfaces.size() != 0) {
                    LCCompilerException[] implErrors = null;
                    LCLog.debug("Performing introspection on %s future candidate interfaces...", driverClass.interfaces.size());
                    for (String iface : driverClass.interfaces) {
                        byte[] ifaceBytes = LCCoreTransformer.$.classCache.getCached(iface);
                        ClassNode ifaceClazz = new ClassNode();
                        new ClassReader(ifaceBytes).accept((ClassVisitor)ifaceClazz, 0);
                        implErrors = InterfaceInspector.introspectImplementation(ifaceClazz, driverClass);
                        if (implErrors == null || implErrors.length == 0) continue;
                        LCLog.warn("%s problems encountered when introspecting interface %s on class %s:", implErrors.length, iface, driverClass.name);
                        for (LCCompilerException exception : implErrors) {
                            LCLog.warn("\t%s", exception.getMessage());
                        }
                        acceptImport = false;
                    }
                    LCLog.debug("Performed future interface introspection successfully.");
                }
                if (!acceptImport || (errors = ClassMerger.mergeClasses(driverClass, sourceNode, false)) == null || errors.length == 0) continue;
                LCLog.warn("%s problems encountered when merging class %s into destination class %s:", errors.length, driverClass.name, sourceNode.name);
                for (LCCompilerException exception : errors) {
                    LCLog.warn("\t%s", exception.getMessage());
                }
            }
        }
        for (Object method : sourceNode.methods) {
            String callMethod;
            AnnotationNode callback = ASMAssist.findAnnotation((MethodNode)method, "Llc/api/jit/DeviceDrivers$DriverRTCallback;");
            if (callback == null || (callMethod = (String)ASMAssist.findValue(callback, "event")) == null) continue;
            events.put(((MethodNode)method).name, callMethod);
        }
        if (events.size() > 0) {
            LCLog.debug("Adding %s event hooks.", events.size());
            boolean hasUserInit = false;
            for (Object o : sourceNode.methods) {
                MethodNode method = (MethodNode)o;
                if (!method.name.equals("<clinit>")) continue;
                LCLog.debug("Moving user's <clinit> block to user_clinit...");
                method.name = "user_clinit";
                method.access = 10;
                hasUserInit = true;
                break;
            }
            MethodNode classInitializer = new MethodNode(8, "<clinit>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
            sourceNode.methods.add(0, classInitializer);
            classInitializer.visitCode();
            for (Map.Entry eventMapItem : events.entrySet()) {
                classInitializer.visitLdcInsn((Object)Type.getObjectType((String)name.replace(".", "/")));
                classInitializer.visitLdcInsn(eventMapItem.getKey());
                classInitializer.visitLdcInsn(eventMapItem.getValue());
                classInitializer.visitMethodInsn(184, "lc/common/base/LCTile", "registerCallback", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)V", false);
            }
            if (hasUserInit) {
                classInitializer.visitMethodInsn(184, sourceNode.name, "user_clinit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
            }
            classInitializer.visitInsn(177);
            classInitializer.visitMaxs(3, 0);
            classInitializer.visitEnd();
        }
        ClassWriter writer = new ClassWriter(1);
        sourceNode.accept((ClassVisitor)writer);
        LCLog.debug("Successfully injected and recompiled class %s.", name);
        return writer.toByteArray();
    }
}

