/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod.compiler;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import lc.common.LCLog;
import lc.coremod.compiler.ICompilerFeature;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassOptionalCompiler
implements ICompilerFeature {
    @Override
    public byte[] compile(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        ArrayList<String> interfaceList = new ArrayList<String>();
        for (Object method : classNode.methods) {
            if (((MethodNode)method).visibleAnnotations == null) continue;
            for (AnnotationNode a : ((MethodNode)method).visibleAnnotations) {
                if (!a.desc.equals("Llc/coremod/RuntimeAnnotation$RuntimeInterface;")) continue;
                int k = a.values.indexOf("modid");
                int l = a.values.indexOf("clazz");
                String modname = (String)a.values.get(k + 1);
                String iface = (String)a.values.get(l + 1);
                if (Loader.isModLoaded((String)modname)) {
                    if (interfaceList.contains(iface)) continue;
                    LCLog.debug("Adding interface %s because mod %s is loaded.", iface, modname);
                    interfaceList.add(iface);
                    continue;
                }
                LCLog.debug("Skipping interface %s because mod %s is not loaded.", iface, modname);
            }
        }
        if (interfaceList.size() > 0) {
            LCLog.debug("Performing total %s ASM operations...", interfaceList.size());
            for (String iface : interfaceList) {
                this.addInterface(classNode, iface);
            }
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private void addInterface(ClassNode clazz, String iface) {
        try {
            Class.forName(iface);
            iface = iface.replace(".", "/");
            if (!clazz.interfaces.contains(iface)) {
                clazz.interfaces.add(iface);
            }
        }
        catch (ClassNotFoundException notfound) {
            LCLog.debug("Attempted to load interface %s into class %s, but it does not exist!", iface, clazz.name);
        }
    }
}

