/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod.compiler;

import java.util.ArrayList;
import java.util.List;
import lc.coremod.ASMAssist;
import lc.coremod.LCCompilerException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassMerger {
    public static LCCompilerException[] mergeClasses(ClassNode source, ClassNode destination, boolean force) {
        ArrayList<LCCompilerException> errors = new ArrayList<LCCompilerException>();
        ClassMerger.walkMergePreconditions(source, destination, errors);
        if (!force && errors.size() != 0) {
            errors.add(new LCCompilerException("Preconditions failed; aborting..."));
            return errors.toArray(new LCCompilerException[0]);
        }
        ClassMerger.performMerge(source, destination, errors);
        if (errors.size() != 0) {
            return errors.toArray(new LCCompilerException[0]);
        }
        return null;
    }

    private static void walkMergePreconditions(ClassNode source, ClassNode dest, List<LCCompilerException> errors) {
        if (source.fields != null && source.fields.size() != 0) {
            for (FieldNode field : source.fields) {
                if (!ClassMerger.hasDuplicateField(field, dest)) continue;
                errors.add(new LCCompilerException("Duplicate field: " + ASMAssist.signature(field)));
            }
        }
        if (source.interfaces != null && source.interfaces.size() != 0) {
            for (String iface : source.interfaces) {
                if (!ClassMerger.hasDuplicateInterface(iface, dest)) continue;
                errors.add(new LCCompilerException("Duplicate interface: " + iface));
            }
        }
        if (source.methods != null && source.methods.size() != 0) {
            for (MethodNode srcMethod : source.methods) {
                MethodNode dstMethod;
                if (!ClassMerger.hasDuplicateMethod(srcMethod, dest) || ASMAssist.isMethodEmpty(srcMethod) || srcMethod.name.equals("<init>") || ASMAssist.isMethodEmpty(dstMethod = ASMAssist.findMethod(dest, srcMethod.name, srcMethod.desc))) continue;
                errors.add(new LCCompilerException("Duplicate non-empty method import: " + ASMAssist.signature(srcMethod)));
            }
        }
    }

    private static boolean hasDuplicateMethod(MethodNode theMethod, ClassNode theClass) {
        return ASMAssist.findMethod(theClass, theMethod.name, theMethod.desc) != null;
    }

    private static boolean hasDuplicateField(FieldNode theField, ClassNode theClass) {
        return ASMAssist.findField(theClass, theField.name) != null;
    }

    private static boolean hasDuplicateInterface(String theInterface, ClassNode theClass) {
        if (theClass.interfaces == null || theClass.interfaces.size() == 0) {
            return false;
        }
        for (String iface : theClass.interfaces) {
            if (!theInterface.equals(iface)) continue;
            return true;
        }
        return false;
    }

    private static void performMerge(ClassNode source, ClassNode dest, List<LCCompilerException> errors) {
        if (source.interfaces != null) {
            for (String iface : source.interfaces) {
                if (dest.interfaces == null) {
                    dest.interfaces = new ArrayList();
                }
                if (!ClassMerger.hasDuplicateInterface(iface, dest)) {
                    dest.interfaces.add(iface);
                    continue;
                }
                errors.add(new LCCompilerException(String.format("Skipped interface %s, interface already applied in class %s.", iface, source.name)));
            }
        }
        if (source.methods != null) {
            for (MethodNode method : source.methods) {
                if (!ClassMerger.hasDuplicateMethod(method, dest)) {
                    dest.methods.add(ClassMerger.remapMethod(source.name, dest.name, method));
                    continue;
                }
                errors.add(new LCCompilerException(String.format("Skipped method %s#%s, method with duplicate signature already exists in class %s.", source.name, ASMAssist.signature(method), dest.name)));
            }
        }
        if (source.fields != null) {
            for (FieldNode field : source.fields) {
                if (!ClassMerger.hasDuplicateField(field, dest)) {
                    dest.fields.add(ClassMerger.remapField(source.name, dest.name, field));
                    continue;
                }
                errors.add(new LCCompilerException(String.format("Skipped field %s#%s, field with duplicate signature already exists in class %s.", source.name, ASMAssist.signature(field), dest.name)));
            }
        }
    }

    private static MethodNode remapMethod(String sourceName, String destName, MethodNode master) {
        InsnList instructions = master.instructions;
        int j = instructions.size();
        for (int i = 0; i < j; ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction instanceof MethodInsnNode) {
                MethodInsnNode callable = (MethodInsnNode)instruction;
                if (!callable.owner.equals(sourceName)) continue;
                callable.owner = destName;
                continue;
            }
            if (!(instruction instanceof FieldInsnNode)) continue;
            FieldInsnNode fieldop = (FieldInsnNode)instruction;
            if (!fieldop.owner.equals(sourceName)) continue;
            fieldop.owner = destName;
        }
        return master;
    }

    private static FieldNode remapField(String sourceName, String destName, FieldNode master) {
        return master;
    }
}

