/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import lc.BuildInfo;
import lc.common.LCLog;
import lc.coremod.HotClassCache;
import lc.coremod.compiler.ICompilerFeature;
import net.minecraft.launchwrapper.IClassTransformer;

public class LCCoreTransformer
implements IClassTransformer {
    private static final List<String> compilerDefs = new ArrayList<String>();
    private final List<ICompilerFeature> compilers = new ArrayList<ICompilerFeature>();
    public static boolean ASM_SUCCESS;
    public static LCCoreTransformer $;
    public final HotClassCache classCache = new HotClassCache();

    public LCCoreTransformer() {
        $ = this;
        ASM_SUCCESS = true;
        for (String compiler : compilerDefs) {
            try {
                this.compilers.add((ICompilerFeature)Class.forName(compiler).newInstance());
                LCLog.debug("Instantiated compiler %s.", compiler);
            }
            catch (Throwable e) {
                LCLog.fatal("Could not instantiate compiler %s.", compiler, e);
            }
        }
        if (BuildInfo.DEBUG) {
            try {
                File vmdir = new File("vm/");
                if (vmdir.exists()) {
                    File[] files;
                    for (File f : files = vmdir.listFiles()) {
                        if (!f.isFile() || !f.exists() || f.equals(vmdir)) continue;
                        try {
                            f.delete();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable t) {
                LCLog.fatal("Failed to set up VM runtime save-to-disk debugger.", t);
            }
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        byte[] result = null;
        byte[] transformed = new byte[bytes.length];
        System.arraycopy(bytes, 0, transformed, 0, transformed.length);
        for (ICompilerFeature compiler : this.compilers) {
            try {
                result = compiler.compile(name, transformedName, transformed);
                if (result == null) {
                    LCLog.fatal("ICompilerFeature %s has corrupted class %s, ignoring the compiler result.", compiler, name);
                    continue;
                }
                transformed = result;
                result = new byte[transformed.length];
                System.arraycopy(transformed, 0, result, 0, result.length);
            }
            catch (Throwable e) {
                LCLog.fatal("ICompilerFeature %s failed to recompile class %s (exception raised), ignoring compiler result.", compiler, name, e);
            }
        }
        if (BuildInfo.DEBUG && name.startsWith("lc.")) {
            try {
                File vmdir = new File("vm/");
                File saveObj = new File(vmdir, name.replace("/", "_").replace(".", "_") + ".class");
                if (!vmdir.exists()) {
                    vmdir.mkdir();
                }
                if (saveObj.exists()) {
                    saveObj.delete();
                }
                FileOutputStream output = new FileOutputStream(saveObj, false);
                output.write(transformed);
                output.close();
            }
            catch (Throwable t) {
                LCLog.fatal("Failed to save runtime implementation of class %s.", name, t);
            }
        }
        this.classCache.suggestCache(name, transformed);
        return transformed;
    }

    static {
        compilerDefs.add("lc.coremod.compiler.ClassOptionalCompiler");
        compilerDefs.add("lc.coremod.compiler.HintInjectionCompiler");
        compilerDefs.add("lc.coremod.compiler.DriverBindingCompiler");
        ASM_SUCCESS = false;
    }
}

