/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod;

import java.util.ArrayList;
import java.util.HashMap;
import lc.common.LCLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class HotClassCache {
    private HashMap<String, byte[]> klassBlobs = new HashMap();
    private ArrayList<String> forcedKlasses = new ArrayList();

    public void forceCache(String suggestedName, byte[] blob) {
        this.klassBlobs.put(suggestedName, blob);
    }

    public void suggestCache(String suggestedName, byte[] blob) {
        ClassNode klass = new ClassNode();
        ClassReader classReader = new ClassReader(blob);
        classReader.accept((ClassVisitor)klass, 0);
        String internalName = klass.name.replace("/", ".");
        if (!suggestedName.equals(internalName)) {
            LCLog.warn("Suggested class name %s invalid, expected %s. Renaming...", suggestedName, internalName);
            suggestedName = internalName;
        }
        boolean doCache = this.forcedKlasses.contains(suggestedName);
        if (suggestedName.startsWith("lc.") || (klass.access & 0x200) != 0) {
            doCache = true;
        }
        if (doCache) {
            this.forceCache(suggestedName, blob);
        }
    }

    public byte[] getCached(String klass) {
        if (!this.forcedKlasses.contains(klass = klass.replace("/", "."))) {
            this.forcedKlasses.add(klass);
        }
        if (!this.klassBlobs.containsKey(klass)) {
            try {
                this.getClass().getClassLoader().loadClass(klass);
            }
            catch (ClassNotFoundException err) {
                LCLog.warn("Can't find class %s.", klass);
            }
        }
        return this.klassBlobs.get(klass);
    }

    public String[] forcedKlasses() {
        return this.forcedKlasses.toArray(new String[0]);
    }

    public String[] cachedKlasses() {
        return this.klassBlobs.keySet().toArray(new String[0]);
    }
}

