/*
 * Decompiled with CFR 0.152.
 */
package lc.coremod;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMAssist {
    public static AnnotationNode findAnnotation(MethodNode method, String className) {
        return ASMAssist.findAnnotation(method.visibleAnnotations, className);
    }

    public static AnnotationNode findAnnotation(ClassNode clazz, String className) {
        return ASMAssist.findAnnotation(clazz.visibleAnnotations, className);
    }

    public static AnnotationNode findAnnotation(FieldNode field, String className) {
        return ASMAssist.findAnnotation(field.visibleAnnotations, className);
    }

    public static AnnotationNode findAnnotation(List<AnnotationNode> nodes, String className) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        for (AnnotationNode node : nodes) {
            if (!node.desc.equals(className)) continue;
            return node;
        }
        return null;
    }

    public static <T> T findValue(AnnotationNode node, String name) {
        if (node.values.indexOf(name) == -1) {
            return null;
        }
        return (T)node.values.get(node.values.indexOf(name) + 1);
    }

    public static String signature(MethodNode aMethod) {
        return ASMAssist.signature(aMethod.name, aMethod.desc);
    }

    public static String signature(FieldNode aField) {
        return ASMAssist.signature(aField.name, aField.desc);
    }

    public static String signature(String aName, String aDesc) {
        return aName + aDesc;
    }

    public static MethodNode[] findMethod(ClassNode clazz, String name) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        if (clazz.methods.size() != 0) {
            for (MethodNode method : clazz.methods) {
                if (!method.name.equals(name)) continue;
                result.add(method);
            }
        }
        return result.toArray(new MethodNode[0]);
    }

    public static MethodNode findMethod(ClassNode clazz, String name, String desc) {
        MethodNode result = null;
        if (clazz.methods.size() != 0) {
            String signature = ASMAssist.signature(name, desc);
            for (MethodNode method : clazz.methods) {
                if (!ASMAssist.signature(method).equals(signature)) continue;
                result = method;
            }
        }
        return result;
    }

    public static FieldNode findField(ClassNode clazz, String name) {
        FieldNode result = null;
        if (clazz.fields.size() != 0) {
            for (FieldNode field : clazz.fields) {
                if (!field.name.equals(name)) continue;
                result = field;
            }
        }
        return result;
    }

    public static boolean isMethodEmpty(MethodNode method) {
        if (method.instructions == null || method.instructions.size() == 0) {
            return true;
        }
        for (AbstractInsnNode insn : method.instructions) {
            int opcode = insn.getOpcode();
            if (opcode == 176 || opcode == 177) continue;
            return false;
        }
        return true;
    }
}

