/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.math;

import java.util.EnumSet;
import java.util.Random;
import lc.common.util.math.Matrix3;
import net.minecraftforge.common.util.ForgeDirection;

public enum Orientations {
    VOID(null, 0.0f),
    NORTH(Matrix3.turnRotations[0], 0.0f),
    SOUTH(Matrix3.turnRotations[2], 180.0f),
    EAST(Matrix3.turnRotations[1], 270.0f),
    WEST(Matrix3.turnRotations[3], 90.0f),
    NORTHEAST(Matrix3.ident, 45.0f),
    SOUTHEAST(Matrix3.ident, 135.0f),
    SOUTHWEST(Matrix3.ident, 225.0f),
    NORTHWEST(Matrix3.ident, 315.0f),
    NORTHSOUTH(Matrix3.ident, 0.0f),
    EASTWEST(Matrix3.ident, 90.0f);

    private final Matrix3 rotation;
    private final float angle;

    private Orientations(Matrix3 rotation, float angle) {
        this.rotation = rotation;
        this.angle = angle;
    }

    public Matrix3 rotation() {
        return this.rotation;
    }

    public static Orientations from(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return VOID;
    }

    public static EnumSet<Orientations> getCardinals() {
        return EnumSet.of(NORTH, EAST, SOUTH, WEST);
    }

    public static Orientations randomCardinal(Random r) {
        return Orientations.values()[1 + r.nextInt(4)];
    }

    public static EnumSet<Orientations> getFacings() {
        return EnumSet.of(NORTH, EAST);
    }

    public float angle() {
        return this.angle;
    }

    public ForgeDirection forge() {
        switch (this) {
            case NORTH: {
                return ForgeDirection.NORTH;
            }
            case SOUTH: {
                return ForgeDirection.SOUTH;
            }
            case EAST: {
                return ForgeDirection.EAST;
            }
            case WEST: {
                return ForgeDirection.WEST;
            }
        }
        return null;
    }
}

