/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.math;

public class MathUtils {
    public static double normaliseAngle(double a) {
        if ((a %= 360.0) < 0.0) {
            a += 360.0;
        }
        return a;
    }

    public static double addAngle(double a, double b) {
        return MathUtils.normaliseAngle(a + b);
    }

    public static double diffAngle(double a, double b) {
        double d;
        double d2 = d = a > b ? a - b : b - a;
        if (d > 180.0) {
            d -= 360.0;
        }
        if (a > b) {
            d = -d;
        }
        return d;
    }

    public static double relaxAngle(double a, double target, double rate) {
        return MathUtils.addAngle(a, rate * MathUtils.diffAngle(a, target));
    }

    public static double interpolateAngle(double a, double b, double t) {
        return MathUtils.addAngle(a, t * MathUtils.diffAngle(a, b));
    }
}

