/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.math;

import lc.common.util.math.DimensionPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ChunkPos {
    public int dimension;
    public int cx;
    public int cz;

    public ChunkPos(TileEntity te) {
        this(te.func_145831_w().field_73011_w.field_76574_g, te.field_145851_c >> 4, te.field_145849_e >> 4);
    }

    public ChunkPos(int dimension, int x, int z) {
        this.dimension = dimension;
        this.cx = x;
        this.cz = z;
    }

    public ChunkPos(int x, int z) {
        this.cx = x;
        this.cz = z;
    }

    public ChunkPos(NBTTagCompound nbt) {
        this.dimension = nbt.func_74762_e("dimension");
        this.cx = nbt.func_74762_e("cx");
        this.cz = nbt.func_74762_e("cz");
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("dimension", this.dimension);
        nbt.func_74768_a("cx", this.cx);
        nbt.func_74768_a("cz", this.cz);
        return nbt;
    }

    public DimensionPos toWorldLocation() {
        return new DimensionPos(this.dimension, this.cx << 4, 0, this.cz << 4);
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void clearDimension() {
        this.dimension = 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cx;
        result = 31 * result + this.cz;
        result = 31 * result + this.dimension;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkPos other = (ChunkPos)obj;
        if (this.cx != other.cx) {
            return false;
        }
        if (this.cz != other.cz) {
            return false;
        }
        return this.dimension == other.dimension;
    }
}

