/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.java;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import lc.common.LCLog;
import lc.common.util.java.DeferredTaskExecutor;

public class DestructableReferenceQueue {
    private static final ArrayList<WeakReference<Object>> map = new ArrayList();
    private Runnable gc = new Runnable(){

        @Override
        public void run() {
            LCLog.debug("Performing reference garbage collection...");
            DestructableReferenceQueue.dereference();
            LCLog.debug("Reference garbage collection completed.");
        }
    };

    private DestructableReferenceQueue() {
        DeferredTaskExecutor.scheduleWithFixedDelay(this.gc, 240L, 300L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queued(Object o) {
        ArrayList<WeakReference<Object>> arrayList = map;
        synchronized (arrayList) {
            for (WeakReference<Object> obj : map) {
                if (obj.get() == null || obj.get() != o) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Object o) {
        ArrayList<WeakReference<Object>> arrayList = map;
        synchronized (arrayList) {
            map.add(new WeakReference<Object>(o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dereference() {
        ArrayList<WeakReference<Object>> arrayList = map;
        synchronized (arrayList) {
            Iterator<WeakReference<Object>> refs = map.iterator();
            while (refs.hasNext()) {
                WeakReference<Object> obj = refs.next();
                if (obj.get() != null) continue;
                refs.remove();
            }
        }
    }
}

