/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.game;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class SlotFilter {
    private ArrayList<ItemStack> accept = new ArrayList();
    private ArrayList<ItemStack> deny = new ArrayList();
    private boolean whitelist;
    private boolean observeMetadata;

    public SlotFilter() {
        new SlotFilter(null, null, false, true);
    }

    public SlotFilter(ItemStack[] accept, ItemStack[] deny) {
        new SlotFilter(accept, deny, false, true);
    }

    public SlotFilter(ItemStack[] accept, ItemStack[] deny, boolean whitelist, boolean metadata) {
        if (accept != null) {
            for (ItemStack item : accept) {
                this.accept.add(new ItemStack(item.func_77973_b(), 1));
            }
        }
        if (deny != null) {
            for (ItemStack item : deny) {
                this.deny.add(new ItemStack(item.func_77973_b(), 1));
            }
        }
        this.whitelist = whitelist;
        this.observeMetadata = metadata;
    }

    public void accept(ItemStack item) {
        this.deny.remove(item);
        this.accept.add(item);
    }

    public void deny(ItemStack item) {
        this.accept.remove(item);
        this.deny.add(item);
    }

    public void remove(ItemStack item) {
        this.accept.remove(item);
        this.deny.remove(item);
    }

    public void setMode(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public boolean test(ItemStack testing) {
        if (testing == null || testing.func_77973_b() == null) {
            return true;
        }
        if (this.whitelist) {
            for (ItemStack s : this.accept) {
                if (!this.isItemVirtuallyEqual(s, testing)) continue;
                return true;
            }
            return false;
        }
        for (ItemStack s : this.deny) {
            if (!this.isItemVirtuallyEqual(s, testing)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemVirtuallyEqual(ItemStack a, ItemStack b) {
        if (a == null || a.func_77973_b() == null) {
            return false;
        }
        if (!a.func_77973_b().equals(b.func_77973_b())) {
            return false;
        }
        return !this.observeMetadata || a.func_77960_j() == b.func_77960_j();
    }
}

