/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.game;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import lc.api.event.ITickEventHandler;
import lc.common.LCLog;
import lc.common.util.Tracer;

public class LCTickConnector {
    protected ReentrantLock childLock = new ReentrantLock();
    protected ArrayList<ITickEventHandler> children = new ArrayList();
    protected ArrayList<ITickEventHandler> newChildren = new ArrayList();

    public LCTickConnector() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void register(ITickEventHandler host) {
        try {
            this.childLock.lock();
            if (!this.newChildren.contains(host)) {
                this.newChildren.add(host);
            }
            this.childLock.unlock();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.childLock.isLocked()) {
                this.childLock.unlock();
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.ServerTickEvent tick) {
        if (tick.phase != TickEvent.Phase.START) {
            return;
        }
        this.update();
        this.doTick(Side.SERVER);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent tick) {
        if (tick.phase != TickEvent.Phase.START) {
            return;
        }
        this.update();
        this.doTick(Side.CLIENT);
    }

    private void update() {
        if (!this.childLock.isLocked() && this.newChildren.size() > 0) {
            try {
                this.childLock.lock();
                for (ITickEventHandler host : this.newChildren) {
                    this.children.add(host);
                }
                this.newChildren.clear();
                this.childLock.unlock();
            }
            catch (Throwable throwable) {
            }
            finally {
                if (this.childLock.isLocked()) {
                    this.childLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTick(Side what) {
        for (ITickEventHandler host : this.children) {
            try {
                Tracer.begin(this, "tick child: " + host.getClass().getName());
                host.think(what);
            }
            catch (Throwable t) {
                LCLog.warn("Unhandled exception in ITickEventHandler.", t);
            }
            finally {
                Tracer.end();
            }
        }
    }
}

