/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.game;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFilter {
    private Block targetBlock;
    private int targetMetadata;

    public BlockFilter(Block block) {
        this(block, -1);
    }

    public BlockFilter(Block block, int metadata) {
        if (block == null) {
            throw new IllegalArgumentException("Cannot create filter on null block type!");
        }
        this.targetBlock = block;
        this.targetMetadata = metadata;
    }

    public boolean matches(World world, int x, int y, int z) {
        Block blockOf = world.func_147439_a(x, y, z);
        if (this.targetBlock.func_149688_o() == Material.field_151579_a && blockOf.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (blockOf.equals(this.targetBlock) && this.targetMetadata == -1) {
            return true;
        }
        return blockOf.equals(this.targetBlock) && this.targetMetadata == world.func_72805_g(x, y, z);
    }

    public Block getBlock() {
        return this.targetBlock;
    }

    public int getMetadata() {
        return this.targetMetadata;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("BlockFilter").append("{");
        result.append(this.targetBlock.getClass().getName()).append(",");
        result.append(this.targetMetadata).append("}");
        return result.toString();
    }
}

