/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util.data;

import lc.common.util.data.ObserverContext;

public class Observable {
    private volatile boolean modified;
    private volatile Observable parent;

    public Observable(Observable parent) {
        this.parent = parent;
    }

    protected void modify() {
        this.modified = true;
        if (this.parent != null) {
            this.parent.modify();
        }
    }

    public boolean modified(ObserverContext context) {
        if (!context.states.containsKey(System.identityHashCode(this))) {
            return true;
        }
        return context.states.get(System.identityHashCode(this)) != (this.modified ? 1 : 0);
    }

    public void clearModified(ObserverContext context) {
        this.modified = false;
        context.states.put(System.identityHashCode(this), this.modified ? 1 : 0);
    }
}

