/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import lc.common.LCLog;
import lc.common.util.data.WindowedArrayList;
import lc.common.util.java.DeferredTaskExecutor;

public class Tracer {
    private static final Tracer tracer = new Tracer();
    private HashMap<String, ProfileHistory> history = new HashMap();
    private HashMap<Long, Stack<String>> labels = new HashMap();
    private ProfilePerformanceWriter writer = new ProfilePerformanceWriter();

    public static void begin(Object z) {
        Tracer.begin(z, null);
    }

    public static void begin(Object z, String what) {
        StackTraceElement src = Tracer.trace();
        if (what != null) {
            tracer.traceEnter((z instanceof Class ? ((Class)z).getName() : z.getClass().getName()) + "#" + src.getMethodName() + ": " + what, src);
        } else {
            tracer.traceEnter((z instanceof Class ? ((Class)z).getName() : z.getClass().getName()) + "#" + src.getMethodName(), src);
        }
    }

    public static void end() {
        tracer.traceExit();
    }

    public static HashMap<String, ProfileHistory> history() {
        return Tracer.tracer.history;
    }

    private static StackTraceElement trace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int pz = 1;
        StackTraceElement src = trace[pz];
        while (src.getClassName().equals("lc.common.util.Tracer")) {
            src = trace[pz++];
        }
        return src;
    }

    private String makeSignature(StackTraceElement tracer) {
        StringBuilder sig = new StringBuilder();
        sig.append(tracer.getClassName()).append("#").append(tracer.getMethodName());
        return sig.toString();
    }

    private void traceEnter(String blob, StackTraceElement tracer) {
        long tz = Thread.currentThread().getId();
        if (!this.labels.containsKey(tz)) {
            this.labels.put(tz, new Stack());
        }
        this.labels.get(tz).push(blob);
        if (!this.history.containsKey(blob)) {
            this.history.put(blob, new ProfileHistory(10, this.makeSignature(tracer)));
        }
        this.history.get((Object)blob).stamp = System.nanoTime();
    }

    private void traceExit() {
        long m0 = System.nanoTime();
        String key = this.makeSignature(Tracer.trace());
        long threadId = Thread.currentThread().getId();
        if (this.labels.get(threadId).size() == 0) {
            LCLog.warn("Tracer: requested trace exit but the trace stack for thread %s is empty.", threadId);
            return;
        }
        String tracer = this.labels.get(threadId).pop();
        ProfileHistory hist = this.history.get(tracer);
        if (hist.sig.equals(key)) {
            hist.push(m0 - hist.stamp);
            return;
        }
        LCLog.warn("Tracer: detected unclosed trace %s on thread %s from call %s, unwinding stack.", threadId, tracer, hist.sig);
        Stack<String> tstack = this.labels.get(threadId);
        while (tstack.size() > 0) {
            tracer = tstack.peek();
            hist = this.history.get(tracer);
            if (hist.sig.equals(key)) {
                hist.push(m0 - hist.stamp);
                LCLog.warn("Tracer: unwound the trace stack on thread %s to trace %s from call %s...", threadId, tracer, hist.sig);
                return;
            }
            LCLog.warn("Tracer: detected nested unclosed trace on thread %s with trace %s from call %s...", tracer, hist.sig);
        }
        LCLog.warn("Tracer: fully unwound the trace stack.");
    }

    static {
        DeferredTaskExecutor.scheduleWithFixedDelay(Tracer.tracer.writer, 90L, 60L, TimeUnit.SECONDS);
    }

    public static class ProfileHistory {
        public volatile long stamp;
        public final String sig;
        public long best = Long.MAX_VALUE;
        public long worst = Long.MIN_VALUE;
        private WindowedArrayList<Long> history;

        public ProfileHistory(int heap, String sig) {
            this.sig = sig;
            this.history = new WindowedArrayList(heap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(long value) {
            if (value > this.worst) {
                this.worst = value;
            }
            if (this.best > value) {
                this.best = value;
            }
            WindowedArrayList<Long> windowedArrayList = this.history;
            synchronized (windowedArrayList) {
                this.history.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float avg() {
            long sum = 0L;
            Long[] longArray = this.history;
            synchronized (this.history) {
                Long[] iheap = this.history.toArray((Long[])new Long[0]);
                // ** MonitorExit[var4_2] (shouldn't be in output)
                for (Long lz : iheap) {
                    sum += lz.longValue();
                }
                return (float)sum / (float)iheap.length;
            }
        }
    }

    public static class ProfilePerformanceWriter
    implements Runnable {
        private File cwd = new File("./logs/lanteacraft/performance.log");

        @Override
        public void run() {
            try {
                LCLog.debug("Saving profiling data...");
                PrintStream stream = new PrintStream(this.cwd);
                DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                df.setMaximumFractionDigits(340);
                HashMap history = (HashMap)Tracer.history().clone();
                for (Map.Entry record : history.entrySet()) {
                    stream.print((String)record.getKey());
                    stream.print(",");
                    ProfileHistory histogram = (ProfileHistory)record.getValue();
                    stream.print(df.format(histogram.best));
                    stream.print(",");
                    stream.print(df.format(histogram.avg()));
                    stream.print(",");
                    stream.print(df.format(histogram.worst));
                    stream.println();
                }
                stream.close();
                LCLog.debug("Saved profiling data to disk.");
            }
            catch (IOException ioex) {
                LCLog.warn("Failed to save profiling data.", ioex);
            }
        }
    }
}

