/*
 * Decompiled with CFR 0.152.
 */
package lc.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import lc.common.LCLog;
import lc.server.HintProviderServer;

public class BeaconStreamThread
extends Thread {
    private final String charset = "UTF-8";
    private final int maxTries = 3;
    private final String serverPath;
    private int tries = 0;
    public boolean finished = false;
    public String report;
    public JsonElement response;

    public BeaconStreamThread(HintProviderServer server) {
        this.setDaemon(true);
        this.setName("LanteaCraft beacon worker");
        this.serverPath = "http://lanteacraft.com/api/" + "beacon";
    }

    public void beacon(HashMap<String, String> payload) {
        if (this.finished) {
            return;
        }
        this.report = new Gson().toJson(payload);
        this.start();
    }

    @Override
    public void run() {
        while (!this.finished && this.tries < 3) {
            try {
                ++this.tries;
                LCLog.debug("Performing beacon task (" + this.tries + "/" + 3 + ")");
                this.runTask();
            }
            catch (IOException ioex) {
                LCLog.warn("Beacon task I/O error.", ioex);
            }
        }
        if (!this.finished) {
            LCLog.warn("Failed to perform beacon task.");
        }
    }

    private void runTask() throws IOException {
        String buffer;
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(this.serverPath).openConnection();
        httpUrlConnection.setConnectTimeout(30000);
        httpUrlConnection.setRequestProperty("Accept-Charset", "UTF-8");
        if (this.report != null) {
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setDoOutput(true);
            OutputStream os = httpUrlConnection.getOutputStream();
            os.write("data=".getBytes("UTF-8"));
            os.write(this.report.getBytes("UTF-8"));
            os.flush();
            os.close();
        } else {
            httpUrlConnection.setRequestMethod("GET");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
        StringBuilder feed = new StringBuilder();
        while ((buffer = in.readLine()) != null) {
            feed.append(buffer);
        }
        in.close();
        String result = feed.toString();
        try {
            this.response = new JsonParser().parse(result);
            this.finished = true;
        }
        catch (Throwable t) {
            throw new IOException("Bad beacon response: `" + result + "`");
        }
    }
}

