/*
 * Decompiled with CFR 0.152.
 */
package lc.common.stargate;

public class StargateCharsetHelper {
    private static StargateCharsetHelper singleton = new StargateCharsetHelper();
    private final char[] radix = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-+".toCharArray();
    public final int radixSize = this.radix.length;

    public static StargateCharsetHelper singleton() {
        return singleton;
    }

    private StargateCharsetHelper() {
    }

    public void legal(String s) {
        for (char c : s.toCharArray()) {
            this.index(c);
        }
    }

    public boolean isLegal(String s) {
        try {
            this.legal(s);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public boolean isLegal(char c) {
        try {
            return this.index(c) > -1;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int index(char c) {
        for (int i = 0; i < this.radix.length; ++i) {
            if (this.radix[i] != c) continue;
            return i;
        }
        throw new NumberFormatException(String.format("Illegal radix value `%s`.", Character.valueOf(c)));
    }

    public char index(int i) {
        if (0 > i || i > this.radix.length) {
            throw new NumberFormatException(String.format("Illegal radix value `%s`.", i));
        }
        return this.radix[i];
    }

    public String longToAddress(long value, int width) {
        char[] buf = new char[width];
        while (width > 0) {
            buf[--width] = this.index((int)(value % (long)this.radix.length));
            value /= (long)this.radix.length;
        }
        if (value != 0L) {
            throw new NumberFormatException("Number too large.");
        }
        return new String(buf);
    }

    public long addressToLong(char[] address) {
        long result = 0L;
        long limit = -9223372036854775807L;
        int i = 0;
        int len = address.length;
        if (len > 0) {
            long multmin = limit / (long)this.radix.length;
            while (i < len) {
                long digit;
                if ((digit = (long)this.index(address[i++])) < 0L) {
                    throw new NumberFormatException("Not a legal radix-38 symbol.");
                }
                if (result < multmin) {
                    throw new NumberFormatException("Out of legal radix-multiplication range.");
                }
                if ((result *= (long)this.radix.length) < limit + digit) {
                    throw new NumberFormatException("Out of legal radix range.");
                }
                result += digit;
            }
        } else {
            throw new NumberFormatException("Not a legal radix-38 number.");
        }
        return result;
    }
}

