/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network.packets.abs;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lc.common.base.LCTile;
import lc.common.network.DropPacketException;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.util.math.DimensionPos;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public abstract class LCTargetPacket
extends LCPacket {
    public DimensionPos target;

    public static void handlePacket(LCTargetPacket packet, EntityPlayer player) throws LCNetworkException {
        if (player.field_70170_p == null || player.field_70170_p.field_73011_w == null) {
            throw new DropPacketException("World not defined right now");
        }
        if (packet.target.dimension != player.field_70170_p.field_73011_w.field_76574_g) {
            throw new DropPacketException("Illegal dimension provided");
        }
        TileEntity tile = player.field_70170_p.func_147438_o(packet.target.x, packet.target.y, packet.target.z);
        if (tile == null) {
            throw new DropPacketException("Tile not loaded");
        }
        if (!(tile instanceof LCTile)) {
            throw new DropPacketException("Not a LanteaCraft tile right now");
        }
        LCTile theTile = (LCTile)tile;
        theTile.handlePacket(packet, player);
    }

    public DimensionPos readDimensionPosFromBuffer(ByteBuf buffer) throws IOException {
        return new DimensionPos(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void writeDimensionPosToBuffer(ByteBuf buffer, DimensionPos target) throws IOException {
        buffer.writeInt(target.dimension).writeInt(target.x).writeInt(target.y).writeInt(target.z);
    }
}

