/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network.packets;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lc.api.stargate.StargateState;
import lc.common.network.packets.abs.LCTargetPacket;
import lc.common.util.math.DimensionPos;

public class LCStargateConnectionPacket
extends LCTargetPacket {
    public StargateState state;
    public int stateTimeout;
    public boolean isSource;

    public LCStargateConnectionPacket() {
    }

    public LCStargateConnectionPacket(DimensionPos target, StargateState state, int stateTimeout, boolean isSource) {
        this.target = target;
        this.state = state;
        this.stateTimeout = stateTimeout;
        this.isSource = isSource;
    }

    @Override
    public void encodeInto(ByteBuf buffer) throws IOException {
        this.writeDimensionPosToBuffer(buffer, this.target);
        buffer.writeInt(this.state.ordinal());
        buffer.writeInt(this.stateTimeout);
        buffer.writeBoolean(this.isSource);
    }

    @Override
    public void decodeFrom(ByteBuf buffer) throws IOException {
        this.target = this.readDimensionPosFromBuffer(buffer);
        this.state = StargateState.values()[buffer.readInt()];
        this.stateTimeout = buffer.readInt();
        this.isSource = buffer.readBoolean();
    }
}

