/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import lc.LCRuntime;
import lc.common.network.LCNetworkController;
import lc.common.network.LCPacket;

public class LCServerToServerEnvelope
extends LCPacket {
    private byte[] data;
    private byte[] signature;

    public static LCServerToServerEnvelope envelope(LCPacket data) throws IOException {
        LCNetworkController controller = LCRuntime.runtime.network();
        ByteBuf buffer = Unpooled.buffer();
        controller.encodePacket(data, buffer);
        return new LCServerToServerEnvelope(buffer.array(), null);
    }

    public static LCPacket unenvelope(LCServerToServerEnvelope envelope) throws IOException {
        LCNetworkController controller = LCRuntime.runtime.network();
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])envelope.data);
        LCPacket packet = controller.decodePacket(buffer);
        return packet;
    }

    public LCServerToServerEnvelope() {
    }

    public LCServerToServerEnvelope(byte[] data, byte[] signature) {
        this.data = data;
        this.signature = signature;
    }

    public byte[] data() {
        return this.data;
    }

    public byte[] signature() {
        return this.signature;
    }

    public void data(byte[] data) {
        this.data = data;
    }

    public void signature(byte[] signature) {
        this.signature = signature;
    }

    public boolean signed() {
        return this.signature != null;
    }

    @Override
    public void encodeInto(ByteBuf buffer) throws IOException {
        if (this.data == null || this.signature == null || this.data.length == 0 || this.signature.length == 0) {
            throw new IOException("Illegal encapsulated packet; no data or unsigned.");
        }
        buffer.writeInt(this.data.length);
        buffer.writeInt(this.signature.length);
        buffer.writeBytes(this.data);
        buffer.writeBytes(this.signature);
    }

    @Override
    public void decodeFrom(ByteBuf buffer) throws IOException {
        this.data = new byte[buffer.readInt()];
        this.signature = new byte[buffer.readInt()];
        buffer.readBytes(this.data);
        buffer.readBytes(this.signature);
    }
}

