/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network.packets;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lc.common.network.packets.abs.LCTargetPacket;
import lc.common.util.data.StateMap;
import lc.common.util.math.DimensionPos;

public class LCRenderSuggestPacket
extends LCTargetPacket {
    private HashMap<String, Object> namedMap;

    public LCRenderSuggestPacket() {
        this.namedMap = new HashMap();
    }

    public LCRenderSuggestPacket(DimensionPos target, StateMap state) {
        this(target, state.raw());
    }

    public LCRenderSuggestPacket(DimensionPos target, HashMap<String, Object> namedMap) {
        this.target = target;
        this.namedMap = namedMap;
    }

    public StateMap toStateMap() {
        StateMap map = new StateMap();
        map.setAllNamed(this.namedMap);
        return map;
    }

    @Override
    public void encodeInto(ByteBuf buffer) throws IOException {
        this.writeDimensionPosToBuffer(buffer, this.target);
        buffer.writeInt(this.namedMap.keySet().size());
        for (Map.Entry<String, Object> entry : this.namedMap.entrySet()) {
            LCRenderSuggestPacket.encodePrimitiveInto(buffer, entry.getKey());
            LCRenderSuggestPacket.encodePrimitiveInto(buffer, entry.getValue());
        }
    }

    @Override
    public void decodeFrom(ByteBuf buffer) throws IOException {
        this.target = this.readDimensionPosFromBuffer(buffer);
        int namedMapSize = buffer.readInt();
        for (int i = 0; i < namedMapSize; ++i) {
            String key = (String)LCRenderSuggestPacket.decodePrimitiveFrom(buffer);
            Object value = LCRenderSuggestPacket.decodePrimitiveFrom(buffer);
            this.namedMap.put(key, value);
        }
    }
}

