/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import lc.common.LCLog;
import lc.common.network.LCNetworkController;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.abs.LCTargetPacket;
import lc.common.util.math.DimensionPos;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.network.ForgeMessage;

@ChannelHandler.Sharable
public class LCPacketPipeline
extends MessageToMessageCodec<FMLProxyPacket, LCPacket> {
    protected EnumMap<Side, FMLEmbeddedChannel> channels;
    private final LCNetworkController controller;

    public LCPacketPipeline(LCNetworkController controller) {
        this.controller = controller;
    }

    public void init(String channelName) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{this});
    }

    protected void encode(ChannelHandlerContext ctx, LCPacket msg, List<Object> out) throws Exception {
        try {
            ByteBuf buffer = Unpooled.buffer();
            this.controller.encodePacket(msg, buffer);
            FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
            out.add(proxyPacket);
        }
        catch (Exception e) {
            LCLog.fatal("Network encode exception.", e);
            throw e;
        }
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        try {
            EntityPlayer player;
            ByteBuf payload = msg.payload();
            LCPacket packet = this.controller.decodePacket(payload);
            switch (FMLCommonHandler.instance().getEffectiveSide()) {
                case CLIENT: {
                    player = this.getClientPlayer();
                    break;
                }
                case SERVER: {
                    INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                    player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                    break;
                }
                default: {
                    throw new LCNetworkException("Instance is not client or server. Cannot continue!");
                }
            }
            if (msg.getTarget() == Side.SERVER) {
                this.controller.serverQueue.queue(packet, msg.getTarget(), player);
            }
            if (msg.getTarget() == Side.CLIENT) {
                this.controller.clientQueue.queue(packet, msg.getTarget(), player);
            }
        }
        catch (Exception e) {
            LCLog.fatal("Network decode exception on side %s, packet dropped.", FMLCommonHandler.instance().getEffectiveSide(), e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(LCPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(LCPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendForgeMessageTo(ForgeMessage message, EntityPlayerMP player) {
        FMLEmbeddedChannel channel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)message);
    }

    public void sendToAllAround(LCPacket message, DimensionPos location, double range) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(location.dimension, (double)location.x, (double)location.y, (double)location.z, range);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(LCPacket message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(LCPacket message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }

    public void sendScoped(LCPacket packet, double range) {
        if (packet instanceof LCTargetPacket) {
            this.sendToAllAround(packet, ((LCTargetPacket)packet).target, range);
        } else {
            this.sendToAll(packet);
        }
    }
}

