/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lc.common.util.math.Vector3;

public abstract class LCPacket {
    public abstract void encodeInto(ByteBuf var1) throws IOException;

    protected static void encodePrimitiveInto(ByteBuf buffer, Object prim) throws IOException {
        if (prim == null) {
            buffer.writeByte(PrimType.NULL.ordinal());
        } else if (prim instanceof Boolean) {
            buffer.writeByte(PrimType.BOOLEAN.ordinal());
            buffer.writeBoolean(((Boolean)prim).booleanValue());
        } else if (prim instanceof Short) {
            buffer.writeByte(PrimType.SHORT.ordinal());
            buffer.writeShort((int)((Short)prim).shortValue());
        } else if (prim instanceof Character) {
            buffer.writeByte(PrimType.CHARACTER.ordinal());
            buffer.writeChar((int)((Character)prim).charValue());
        } else if (prim instanceof Integer) {
            buffer.writeByte(PrimType.INTEGER.ordinal());
            buffer.writeInt(((Integer)prim).intValue());
        } else if (prim instanceof Float) {
            buffer.writeByte(PrimType.FLOAT.ordinal());
            buffer.writeFloat(((Float)prim).floatValue());
        } else if (prim instanceof Double) {
            buffer.writeByte(PrimType.DOUBLE.ordinal());
            buffer.writeDouble(((Double)prim).doubleValue());
        } else if (prim instanceof String) {
            buffer.writeByte(PrimType.STRING.ordinal());
            char[] data = ((String)prim).toCharArray();
            buffer.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                buffer.writeByte((int)((byte)data[i]));
            }
        } else if (prim instanceof Vector3) {
            buffer.writeByte(PrimType.VECTOR.ordinal());
            Vector3 vec = (Vector3)prim;
            buffer.writeDouble(vec.x);
            buffer.writeDouble(vec.y);
            buffer.writeDouble(vec.z);
        } else {
            throw new IOException("Unknown primitive type " + prim.getClass().getName());
        }
    }

    protected static void encodePrimitiveArrayInto(ByteBuf buffer, Object[] arr) throws IOException {
        if (arr == null) {
            buffer.writeInt(-1);
        } else {
            buffer.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                LCPacket.encodePrimitiveInto(buffer, arr[i]);
            }
        }
    }

    public abstract void decodeFrom(ByteBuf var1) throws IOException;

    protected static Object decodePrimitiveFrom(ByteBuf buffer) throws IOException {
        byte typeof = buffer.readByte();
        switch (PrimType.values()[typeof]) {
            case BOOLEAN: {
                return buffer.readBoolean();
            }
            case DOUBLE: {
                return buffer.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(buffer.readFloat());
            }
            case CHARACTER: {
                return Character.valueOf(buffer.readChar());
            }
            case INTEGER: {
                return buffer.readInt();
            }
            case NULL: {
                return null;
            }
            case SHORT: {
                return buffer.readShort();
            }
            case STRING: {
                int str_sz = buffer.readInt();
                StringBuilder data = new StringBuilder();
                for (int i = 0; i < str_sz; ++i) {
                    data.append((char)buffer.readByte());
                }
                return data.toString();
            }
            case VECTOR: {
                return new Vector3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }
        throw new IOException("Unknown primitive type " + typeof);
    }

    protected static Object[] decodePrimitiveArrayFrom(ByteBuf buffer) throws IOException {
        int sz = buffer.readInt();
        if (sz == -1) {
            return null;
        }
        Object[] prims = new Object[sz];
        for (int i = 0; i < sz; ++i) {
            prims[i] = LCPacket.decodePrimitiveFrom(buffer);
        }
        return prims;
    }

    private static enum PrimType {
        NULL,
        BOOLEAN,
        SHORT,
        CHARACTER,
        INTEGER,
        FLOAT,
        DOUBLE,
        STRING,
        VECTOR;

    }
}

