/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import lc.api.event.ITickEventHandler;
import lc.common.LCLog;
import lc.common.network.DropPacketException;
import lc.common.network.LCNetworkController;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCNetworkHandshake;
import lc.common.network.packets.LCServerToServerEnvelope;
import lc.common.network.packets.abs.LCTargetPacket;
import lc.common.util.Tracer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class LCNetworkQueue
implements ITickEventHandler {
    private final LinkedBlockingQueue<QueuedPacket> queue = new LinkedBlockingQueue();
    private final ArrayList<QueuedPacket> drain = new ArrayList();
    private final LCNetworkController controller;
    private final String name;

    public LCNetworkQueue(LCNetworkController controller, String name) {
        this.controller = controller;
        this.name = name;
    }

    public void queue(LCPacket packet, Side target, EntityPlayer player) {
        this.queue.offer(new QueuedPacket(packet, target, player));
    }

    @Override
    public void think(Side what) {
        Tracer.begin(this, "process queue: " + this.name);
        this.queue.drainTo(this.drain);
        Iterator<QueuedPacket> stack = this.drain.iterator();
        while (stack.hasNext()) {
            try {
                QueuedPacket obj = stack.next();
                EntityPlayer player = (EntityPlayer)obj.player.get();
                if (player == null) {
                    throw new DropPacketException("Packet enqueued without player or with dead reference");
                }
                LCPacket packet = obj.packet;
                if (packet instanceof LCNetworkHandshake) {
                    if (obj.target == Side.SERVER) {
                        this.controller.players.get(player).handleHandshakePacket(player, (LCNetworkHandshake)packet, obj.target);
                    }
                    if (obj.target != Side.CLIENT) continue;
                    this.controller.clientPlayer.handleHandshakePacket(player, (LCNetworkHandshake)packet, obj.target);
                    continue;
                }
                if (packet instanceof LCTargetPacket) {
                    LCTargetPacket target = (LCTargetPacket)packet;
                    LCTargetPacket.handlePacket(target, player);
                    continue;
                }
                if (packet instanceof LCServerToServerEnvelope) {
                    LCServerToServerEnvelope envelope = (LCServerToServerEnvelope)packet;
                    if (obj.target == Side.CLIENT) {
                        this.controller.envelopeBuffer.addPacket(envelope);
                        continue;
                    }
                    this.controller.players.get(player).addEnvelopePacket(player, envelope);
                    continue;
                }
                throw new DropPacketException(String.format("Unsupported packet %s.", packet.getClass().getName()));
            }
            catch (DropPacketException exception) {
                LCLog.warn("Dropping network packet.", exception);
            }
            catch (LCNetworkException exception) {
                LCLog.warn("Problem handling packet in queue.", exception);
            }
        }
        LCLog.doSoftAssert(this.drain.size() == 0, "Network drain not empty before clear: still have %s to go", this.drain.size());
        this.drain.clear();
        Tracer.end();
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private static class QueuedPacket {
        public final LCPacket packet;
        public final Side target;
        public final WeakReference<EntityPlayer> player;

        public QueuedPacket(LCPacket packet, Side target, EntityPlayer player) {
            this.packet = packet;
            this.target = target;
            this.player = new WeakReference<EntityPlayer>(player);
        }
    }
}

