/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import lc.LCRuntime;
import lc.common.LCLog;
import lc.common.crypto.DSAProvider;
import lc.common.crypto.KeyTrustRegistry;
import lc.common.network.LCNetworkController;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.LCPacketBuffer;
import lc.common.network.packets.LCNetworkHandshake;
import lc.common.network.packets.LCServerToServerEnvelope;
import lc.server.HintProviderServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class LCNetworkPlayer {
    private final LCNetworkController controller;
    public int expectedEnvelopes;
    private LCPacketBuffer<LCServerToServerEnvelope> envelopes;

    public LCNetworkPlayer(LCNetworkController controller) {
        this.controller = controller;
    }

    public void initialize(EntityPlayerMP player) {
        LCLog.debug("Creating LanteaCraft Enhanced network player %s.", player);
    }

    public void shutdown(EntityPlayerMP player) {
        LCLog.debug("Terminating LanteaCraft Enhanced network player %s.", player);
    }

    public void sendHandshake(EntityPlayer player) {
        this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.SERVER_HELLO, new Object[0]), (EntityPlayerMP)player);
    }

    public void handleHandshakePacket(EntityPlayer player, LCNetworkHandshake packet, Side target) {
        if (target == Side.CLIENT) {
            if (packet.reason == LCNetworkHandshake.HandshakeReason.SERVER_HELLO) {
                LCLog.debug("Got HELLO handshake from LanteaCraft Enhanced server.");
                ArrayList<LCServerToServerEnvelope> pending = this.controller.envelopeBuffer.packets();
                this.controller.getPreferredPipe().sendToServer(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.CLIENT_HELLO, pending.size()));
                for (int i = 0; i < pending.size(); ++i) {
                    this.controller.getPreferredPipe().sendToServer(pending.get(i));
                }
            } else {
                LCLog.warn(new Object[]{"Strange handshake packet on client from server: %s", packet.reason});
            }
        } else if (packet.reason == LCNetworkHandshake.HandshakeReason.CLIENT_HELLO) {
            this.expectedEnvelopes = (Integer)packet.parameters[0];
            LCLog.debug("Got client HELLO response, expecting %s pending datagrams.", this.expectedEnvelopes);
        } else {
            LCLog.warn(new Object[]{"Strange handshake packet on server from client: %s", packet.reason});
        }
    }

    public void addEnvelopePacket(EntityPlayer player, LCServerToServerEnvelope envelope) {
        if (this.envelopes == null) {
            this.envelopes = new LCPacketBuffer();
        }
        this.envelopes.addPacket(envelope);
        if (this.envelopes.size() >= this.expectedEnvelopes) {
            try {
                KeyTrustRegistry registry = ((HintProviderServer)LCRuntime.runtime.hints()).getTrustChain();
                PublicKey[] allKeys = registry.contents();
                ArrayList<LCServerToServerEnvelope> blobs = this.envelopes.packets();
                PublicKey foundKey = null;
                for (PublicKey aKey : allKeys) {
                    if (!DSAProvider.verify(blobs.get(0).signature(), blobs.get(0).data(), aKey)) continue;
                    foundKey = aKey;
                }
                if (foundKey == null) {
                    this.envelopes.clear();
                    this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.SECURITY_ERROR, 2), (EntityPlayerMP)player);
                    throw new LCNetworkException("No public key found for signed payload. Dropping contents.");
                }
                for (LCServerToServerEnvelope blob : blobs) {
                    if (DSAProvider.verify(blob.signature(), blob.data(), foundKey)) continue;
                    this.envelopes.clear();
                    this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.SECURITY_ERROR, 3), (EntityPlayerMP)player);
                    throw new LCNetworkException("Found invalid siganture for signed data. Possibly tampered or invalid packets!");
                }
                for (LCServerToServerEnvelope blob : blobs) {
                    LCPacket packet = LCServerToServerEnvelope.unenvelope(blob);
                    this.controller.injectPacket(Side.SERVER, packet, player);
                }
            }
            catch (IOException ex) {
                this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.NEGOTIATION_ERROR, 1), (EntityPlayerMP)player);
                LCLog.warn("Problem unpacking enveloped data.", ex);
            }
            catch (LCNetworkException ex) {
                this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.NEGOTIATION_ERROR, 1), (EntityPlayerMP)player);
                LCLog.warn("Problem handling enveloped packets.", ex);
            }
            catch (InvalidKeyException ex) {
                this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.NEGOTIATION_ERROR, 1), (EntityPlayerMP)player);
                LCLog.warn("Problem with local key storage.", ex);
            }
            catch (SignatureException ex) {
                this.controller.getPreferredPipe().sendTo(new LCNetworkHandshake(LCNetworkHandshake.HandshakeReason.NEGOTIATION_ERROR, 1), (EntityPlayerMP)player);
                LCLog.fatal("Failed to handle cryptographic data.", ex);
            }
        }
    }
}

