/*
 * Decompiled with CFR 0.152.
 */
package lc.common.network;

import com.google.gson.JsonObject;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.WeakHashMap;
import lc.LCRuntime;
import lc.api.event.ITickEventHandler;
import lc.common.LCLog;
import lc.common.network.LCNetworkPlayer;
import lc.common.network.LCNetworkQueue;
import lc.common.network.LCPacket;
import lc.common.network.LCPacketBuffer;
import lc.common.network.LCPacketPipeline;
import lc.common.network.packets.LCServerToServerEnvelope;
import lc.common.util.BeaconStreamThread;
import lc.server.HintProviderServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class LCNetworkController
implements ITickEventHandler {
    private final LCPacketPipeline pipe = new LCPacketPipeline(this);
    protected final LCNetworkQueue serverQueue = new LCNetworkQueue(this, "Client queue");
    protected final LCNetworkQueue clientQueue = new LCNetworkQueue(this, "Server queue");
    protected final LCPacketBuffer<LCServerToServerEnvelope> envelopeBuffer = new LCPacketBuffer();
    protected final LCNetworkPlayer clientPlayer = new LCNetworkPlayer(this);
    protected final WeakHashMap<EntityPlayerMP, LCNetworkPlayer> players = new WeakHashMap();

    public void init(LCRuntime runtime, FMLInitializationEvent event) {
        this.pipe.init("LanteaCraft");
        runtime.ticks().register(this);
    }

    public LCPacketPipeline getPreferredPipe() {
        return this.pipe;
    }

    public void encodePacket(LCPacket packet, ByteBuf stream) throws IOException {
        Class<?> clazz = packet.getClass();
        LCPacket.encodePrimitiveInto(stream, clazz.getName());
        packet.encodeInto(stream);
    }

    public LCPacket decodePacket(ByteBuf stream) throws IOException {
        String clazzName = (String)LCPacket.decodePrimitiveFrom(stream);
        try {
            Class<?> clazz = Class.forName(clazzName);
            LCPacket packet = (LCPacket)clazz.newInstance();
            packet.decodeFrom(stream.slice());
            return packet;
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException("Decoding exception", ex);
        }
    }

    @Override
    public void think(Side what) {
        if (what == Side.SERVER) {
            this.serverQueue.think(what);
        }
        if (what == Side.CLIENT) {
            this.clientQueue.think(what);
        }
    }

    public void injectPacket(Side side, LCPacket packet, EntityPlayer player) {
        if (side == Side.CLIENT) {
            this.clientQueue.queue(packet, side, player);
        }
        if (side == Side.SERVER) {
            this.serverQueue.queue(packet, side, player);
        }
    }

    public void playerConnected(EntityPlayerMP player) {
        if (!this.players.containsKey(player)) {
            this.players.put(player, new LCNetworkPlayer(this));
            this.players.get(player).initialize(player);
        }
        LCLog.debug("Sending LanteaCraft server handshake to client.");
        this.players.get(player).sendHandshake((EntityPlayer)player);
        BeaconStreamThread appGlobalData = ((HintProviderServer)LCRuntime.runtime.hints()).stats();
        JsonObject globalSvcData = (JsonObject)appGlobalData.response;
        if (globalSvcData != null && globalSvcData.has("notifyPlayerRequired") && globalSvcData.get("notifyPlayerRequired").getAsBoolean()) {
            player.func_145747_a((IChatComponent)new ChatComponentText(globalSvcData.get("notifyPlayerText").getAsString()));
        }
    }

    public void playerDisconnected(EntityPlayerMP player) {
        if (!this.players.containsKey(player)) {
            LCLog.warn("Detected playerDisconnected but could not find network player.");
            return;
        }
        this.players.get(player).shutdown(player);
        this.players.remove(player);
    }

    public void serverShutdown() {
        this.players.clear();
    }
}

