/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lc.LCRuntime;
import lc.api.components.IStructureRegistry;
import lc.api.defs.IStructureDefinition;
import lc.common.LCLog;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class StructureRegistry
implements IStructureRegistry {
    private final Map<String, IStructureDefinition> definitionPool = new HashMap<String, IStructureDefinition>();
    private final Map<Class<? extends StructureStart>, List<IStructureDefinition>> typeCache = new HashMap<Class<? extends StructureStart>, List<IStructureDefinition>>();

    @Override
    public void register(IStructureDefinition definition) {
        if (this.definitionPool.containsKey(definition.getName().toLowerCase())) {
            throw new RuntimeException("Attempt to overwrite existing definition " + definition.getName());
        }
        this.definitionPool.put(definition.getName().toLowerCase(), definition);
    }

    @Override
    public IStructureDefinition getDefinition(String name) {
        return this.definitionPool.get(name.toLowerCase());
    }

    public void init(LCRuntime runtime, FMLInitializationEvent event) {
        for (Map.Entry<String, IStructureDefinition> entry : this.definitionPool.entrySet()) {
            LCLog.debug("Registering structure %s (class: %s)", entry.getValue().getName(), entry.getValue().getStructureClass().getName());
            MapGenStructureIO.func_143034_b(entry.getValue().getStructureClass(), (String)entry.getValue().getName());
            Map<String, Class<? extends StructureComponent>> comps = entry.getValue().getAllComponents();
            for (Map.Entry<String, Class<? extends StructureComponent>> comp : comps.entrySet()) {
                LCLog.debug("Registring component %s (class: %s)", comp.getKey(), comp.getValue().getName());
                MapGenStructureIO.func_143031_a(comp.getValue(), (String)comp.getKey());
            }
        }
    }

    public IStructureDefinition[] allDefs(Class<? extends StructureStart> type) {
        if (!this.typeCache.containsKey(type)) {
            this.typeCache.put(type, new ArrayList());
            for (IStructureDefinition def : this.definitionPool.values()) {
                if (!def.getStructureClass().equals(type) && !type.isAssignableFrom(def.getStructureClass())) continue;
                this.typeCache.get(type).add(def);
            }
        }
        return this.typeCache.get(type).toArray(new IStructureDefinition[0]);
    }
}

