/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import lc.api.defs.IDefinitionReference;
import lc.api.defs.IStructureDefinition;
import lc.api.jit.AnyPredicate;
import lc.common.LCLog;
import lc.common.impl.registry.DefinitionReference;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public abstract class StructureDefinition
implements IStructureDefinition {
    private final String name;
    private final Class<? extends StructureStart> startClazz;
    private final HashMap<String, Class<? extends StructureComponent>> components;

    public StructureDefinition(String name, Class<? extends StructureStart> startClazz) {
        this.name = name;
        this.startClazz = startClazz;
        this.components = new HashMap();
    }

    public StructureDefinition addComp(String name, Class<? extends StructureComponent> component) {
        this.components.put(name, component);
        return this;
    }

    @Override
    public IDefinitionReference ref() {
        return new DefinitionReference(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends StructureStart> getStructureClass() {
        return this.startClazz;
    }

    @Override
    public Map<String, Class<? extends StructureComponent>> getAllComponents() {
        return this.components;
    }

    @Override
    public boolean canGenerateAt(World world, Random rng, int x, int z) {
        AnyPredicate test = this.getGeneratorPredicate();
        if (test == null) {
            return false;
        }
        try {
            return test.test(new Object[]{world, rng, x, z});
        }
        catch (Throwable t) {
            LCLog.warn("Failed to test AnyPredicate rule for generation.", t);
            return false;
        }
    }

    protected abstract AnyPredicate getGeneratorPredicate();
}

