/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import java.util.HashMap;
import java.util.Map;
import lc.api.components.RecipeType;
import lc.api.defs.IDefinitionReference;
import lc.api.defs.IRecipeDefinition;
import lc.common.impl.registry.DefinitionReference;
import lc.common.util.Tracer;
import lc.common.util.game.DataResolver;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class SimpleRecipeDefinition
implements IRecipeDefinition {
    private String name;
    private RecipeType type;
    private HashMap<Integer, Object> inputs;
    private HashMap<Integer, Object> outputs;
    private HashMap<Integer, ItemStack> stackInputs;
    private HashMap<Integer, ItemStack> stackOutputs;
    private HashMap<Integer, Boolean> use;

    public SimpleRecipeDefinition(String name, RecipeType type, Object output, String grid, Object ... inputs) {
        this.name = name;
        this.type = type;
        this.inputs = new HashMap();
        this.outputs = new HashMap();
        this.use = new HashMap();
        for (int i = 0; i < 9; ++i) {
            this.use.put(i, true);
        }
        this.outputs.put(0, output);
        char[] cells = grid.toCharArray();
        for (int i = 0; i < cells.length; ++i) {
            char cell = cells[i];
            if (!Character.isDigit(cell) || cell == ' ') continue;
            this.inputs.put(i, inputs[Character.getNumericValue(cell)]);
        }
    }

    @Override
    public void evaluateRecipe() {
        Tracer.begin(this);
        this.stackInputs = new HashMap();
        for (Map.Entry<Integer, Object> entry : this.inputs.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!(entry.getValue() instanceof ItemStack)) {
                this.stackInputs.put(entry.getKey(), DataResolver.resolve(entry.getValue()));
                continue;
            }
            this.stackInputs.put(entry.getKey(), (ItemStack)entry.getValue());
        }
        this.stackOutputs = new HashMap();
        for (int i = 0; i < this.outputs.size(); ++i) {
            Object val = this.outputs.get(i);
            if (!(val instanceof ItemStack)) {
                this.stackOutputs.put(i, DataResolver.resolve(val));
                continue;
            }
            this.stackOutputs.put(i, (ItemStack)val);
        }
        Tracer.end();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RecipeType getType() {
        return this.type;
    }

    @Override
    public Map<Integer, ItemStack> getInputStacks() {
        return this.stackInputs;
    }

    @Override
    public Map<Integer, Boolean> getInputConsumption() {
        return this.use;
    }

    @Override
    public Map<Integer, ItemStack> getOutputStacks() {
        return this.stackOutputs;
    }

    @Override
    public IRecipe getParentObject() {
        return null;
    }

    @Override
    public Class<? extends IRecipe> getParentClass() {
        return null;
    }

    @Override
    public IDefinitionReference ref() {
        return new DefinitionReference(this);
    }

    public String toString() {
        StringBuilder def = new StringBuilder();
        def.append(this.name).append(": {");
        def.append((Object)this.type).append(", ");
        if (this.stackInputs == null) {
            def.append("[");
            for (Map.Entry<Integer, Object> input : this.inputs.entrySet()) {
                def.append(input.getKey()).append("=").append(input.getValue()).append(",");
            }
            def.append("] => [");
            for (Map.Entry<Integer, Object> outputs : this.outputs.entrySet()) {
                def.append(outputs.getKey()).append("=").append(outputs.getValue()).append(",");
            }
            def.append("], UNRESOLVED }");
        } else {
            def.append("[");
            for (Map.Entry<Integer, ItemStack> input : this.stackInputs.entrySet()) {
                def.append(input.getKey()).append("=").append(input.getValue()).append(",");
            }
            def.append("] => [");
            for (Map.Entry<Integer, ItemStack> outputs : this.stackOutputs.entrySet()) {
                def.append(outputs.getKey()).append("=").append(outputs.getValue()).append(",");
            }
            def.append("], RESOLVED }");
        }
        return def.toString();
    }
}

