/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lc.LCRuntime;
import lc.api.components.IRecipeRegistry;
import lc.api.components.RecipeType;
import lc.api.defs.IRecipeDefinition;
import lc.common.LCLog;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;

public class RecipeRegistry
implements IRecipeRegistry {
    private final Map<String, IRecipeDefinition> definitionPool = new HashMap<String, IRecipeDefinition>();

    @Override
    public void addRecipe(IRecipeDefinition definition) {
        if (this.definitionPool.containsKey(definition.getName().toLowerCase())) {
            throw new RuntimeException("Attempt to overwrite existing definition " + definition.getName());
        }
        this.definitionPool.put(definition.getName().toLowerCase(), definition);
    }

    @Override
    public IRecipeDefinition getRecipe(String name) {
        return this.definitionPool.get(name.toLowerCase());
    }

    public void init(LCRuntime runtime, FMLInitializationEvent event) {
        for (Map.Entry<String, IRecipeDefinition> entry : this.definitionPool.entrySet()) {
            Map<Integer, ItemStack> out;
            Map<Integer, ItemStack> in;
            entry.getValue().evaluateRecipe();
            LCLog.debug(new Object[]{"Setting up recipe %s (type: %s)", entry.getValue().getName(), entry.getValue().getType()});
            IRecipeDefinition definition = entry.getValue();
            RecipeType type = definition.getType();
            if (type == RecipeType.SHAPELESS) {
                in = definition.getInputStacks();
                out = definition.getOutputStacks();
                if (out.size() != 1 || !out.containsKey(0)) {
                    LCLog.fatal("Bad recipe %s: expected 1 output stack for shapeless, got %s.", definition.getName(), out.size());
                }
                ItemStack[] inputs = in.values().toArray(new ItemStack[0]);
                CraftingManager.func_77594_a().func_77596_b(out.get(0), (Object[])inputs);
                continue;
            }
            if (type == RecipeType.SHAPED) {
                in = definition.getInputStacks();
                out = definition.getOutputStacks();
                if (out.size() != 1 || !out.containsKey(0)) {
                    LCLog.fatal("Bad recipe %s: expected 1 output stack for shaped, got %s.", definition.getName(), out.size());
                }
                StringBuilder[] grid = new StringBuilder[3];
                ArrayList<Character> qt = new ArrayList<Character>();
                for (int i = 0; i < 3; ++i) {
                    grid[i] = new StringBuilder();
                    for (int j = 0; j < 3; ++j) {
                        int q = 3 * i + j;
                        if (in.get(q) != null) {
                            grid[i].append(q);
                            qt.add(Character.valueOf(Integer.toString(q).charAt(0)));
                            qt.add((Character)in.get(q));
                            continue;
                        }
                        grid[i].append(" ");
                    }
                }
                ArrayList<Object> varargs = new ArrayList<Object>();
                varargs.add(grid[0].toString());
                varargs.add(grid[1].toString());
                varargs.add(grid[2].toString());
                varargs.addAll(qt);
                LCLog.debug("Adding shaped recipe: [ '%s', '%s', '%s' ]", grid[0].toString(), grid[1].toString(), grid[2].toString());
                CraftingManager.func_77594_a().func_92103_a(out.get(0), varargs.toArray());
                continue;
            }
            if (type == RecipeType.SMELTING) {
                in = definition.getInputStacks();
                if (in.size() != 1 || !in.containsKey(0)) {
                    LCLog.fatal("Bad recipe %s: expected 1 input stack for smelting, got %s.", definition.getName(), in.size());
                }
                if ((out = definition.getOutputStacks()).size() != 1 || !out.containsKey(0)) {
                    LCLog.fatal("Bad recipe %s: expected 1 output stack for smelting, got %s.", definition.getName(), out.size());
                }
                FurnaceRecipes.func_77602_a().func_151394_a(in.get(0), out.get(0), 0.0f);
                continue;
            }
            if (type == RecipeType.PROXY) {
                GameRegistry.addRecipe((IRecipe)definition.getParentObject());
                continue;
            }
            LCLog.fatal(new Object[]{"Cannot handle recipe type %s. Panic!", type});
        }
    }
}

