/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import java.lang.annotation.Annotation;
import lc.LCRuntime;
import lc.api.components.ComponentType;
import lc.api.defs.Definition;
import lc.api.defs.IContainerDefinition;
import lc.common.LCLog;
import lc.common.impl.registry.BlockItemDefinition;
import lc.common.impl.registry.EntityDefinition;

public class DefinitionWrapperProvider {
    public static IContainerDefinition provide(Class<?> clazz) {
        Annotation[] annotations;
        LCLog.debug("Attempting to provide definition for class %s.", clazz);
        IContainerDefinition result = null;
        for (Annotation annotation : annotations = clazz.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(Definition.class)) continue;
            Definition definition = (Definition)annotation;
            String name = definition.name();
            ComponentType type = definition.type();
            Class<?> blockClass = null;
            Class<?> itemBlockClass = null;
            Class<?> itemClass = null;
            Class<?> tileClass = null;
            Class<?> entityClass = null;
            if (!definition.blockClass().equals(Void.class) && !definition.itemBlockClass().equals(Void.class)) {
                LCLog.doAssert(definition.itemClass().equals(Void.class), "Definition Block specifies Item, not allowed.");
                blockClass = definition.blockClass();
                itemBlockClass = definition.itemBlockClass();
                if (!definition.tileClass().equals(Void.class)) {
                    tileClass = definition.tileClass();
                }
                result = new BlockItemDefinition(type, name, blockClass, itemBlockClass).setTileType(tileClass);
                LCLog.trace(new Object[]{"Providing definition: %s: %s, block: %s, itemblock: %s, tile: %s", type, name, blockClass, itemBlockClass, tileClass});
                continue;
            }
            if (!definition.itemClass().equals(Void.class)) {
                LCLog.doAssert(definition.blockClass().equals(Void.class), "Definition Item specifies Block, not allowed.");
                LCLog.doAssert(definition.tileClass().equals(Void.class), "Definition Item specifies Tile, not allowed.");
                itemClass = definition.itemClass();
                result = new BlockItemDefinition(type, name, null, itemClass);
                LCLog.trace(new Object[]{"Providing definition: %s: %s, item: %s", type, name, itemClass});
                continue;
            }
            if (!definition.entityClass().equals(Void.class)) {
                entityClass = definition.entityClass();
                result = new EntityDefinition(type, name, entityClass);
                continue;
            }
            LCLog.warn("No valid definition found, ignoring.");
        }
        if (result != null) {
            LCRuntime.runtime.registries().definitions().addDefinition(result);
        } else {
            LCLog.warn("Object %s requested for definition, none made.", clazz.getName());
        }
        return result;
    }
}

