/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import lc.LCRuntime;
import lc.api.components.ComponentType;
import lc.api.components.IComponentRegistry;
import lc.api.components.IDefinitionRegistry;
import lc.api.defs.IContainerDefinition;
import lc.api.defs.ILanteaCraftRenderer;
import lc.common.LCLog;
import lc.common.base.LCBlock;
import lc.common.base.LCBlockRenderer;
import lc.common.base.LCEntityRenderer;
import lc.common.base.LCItem;
import lc.common.base.LCItemBucket;
import lc.common.base.LCItemRenderer;
import lc.common.base.LCTile;
import lc.common.base.LCTileRenderer;
import lc.common.configuration.IConfigure;
import lc.common.impl.registry.BlockItemDefinition;
import lc.common.impl.registry.EntityDefinition;
import lc.common.util.LCCreativeTabManager;
import lc.common.util.Tracer;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class DefinitionRegistry
implements IDefinitionRegistry {
    private final Map<String, IContainerDefinition> definitionPool = new HashMap<String, IContainerDefinition>();
    private final Map<RendererType, Map<Class<?>, Class<? extends ILanteaCraftRenderer>>> registeredRenderers = new HashMap();
    private final Map<RendererType, Map<Class<?>, ILanteaCraftRenderer>> initializedRenderers = new HashMap();

    @Override
    public void addDefinition(IContainerDefinition definition) {
        if (this.definitionPool.containsKey(definition.getName().toLowerCase())) {
            throw new RuntimeException("Attempt to overwrite existing definition " + definition.getName());
        }
        this.definitionPool.put(definition.getName().toLowerCase(), definition);
    }

    @Override
    public IContainerDefinition getDefinition(String name) {
        return this.definitionPool.get(name.toLowerCase());
    }

    public void init(LCRuntime runtime, FMLInitializationEvent event) {
        Tracer.begin(this);
        IComponentRegistry components = runtime.registries().components();
        LCLog.debug("Evaluating %s definitions for candidacy.", this.definitionPool.size());
        for (IContainerDefinition definition : this.definitionPool.values()) {
            IContainerDefinition element;
            if (definition instanceof BlockItemDefinition) {
                element = (BlockItemDefinition)definition;
                if (components.isEnabled(((BlockItemDefinition)element).getComponentOwner())) {
                    LCLog.trace(new Object[]{"Registering element %s, component %s enabled.", ((BlockItemDefinition)element).getName(), ((BlockItemDefinition)element).getComponentOwner()});
                    ((BlockItemDefinition)element).init(this);
                    continue;
                }
                LCLog.trace(new Object[]{"Dropping registration for element %s, component %s disabled.", ((BlockItemDefinition)element).getName(), ((BlockItemDefinition)element).getComponentOwner()});
                continue;
            }
            if (definition instanceof EntityDefinition) {
                element = (EntityDefinition)definition;
                if (components.isEnabled(((EntityDefinition)element).getComponentOwner())) {
                    LCLog.trace(new Object[]{"Registering element %s, component %s enabled.", ((EntityDefinition)element).getName(), ((EntityDefinition)element).getComponentOwner()});
                    ((EntityDefinition)element).init(this);
                    continue;
                }
                LCLog.trace(new Object[]{"Dropping registration for element %s, component %s disabled.", ((EntityDefinition)element).getName(), ((EntityDefinition)element).getComponentOwner()});
                continue;
            }
            LCLog.warn("Strange definition type %s, ignoring it.", definition.getClass().getName());
        }
        Tracer.end();
    }

    public <T extends Block> T registerBlock(Class<? extends T> classOf, Class<? extends ItemBlock> itemClassOf, String unlocalizedName, ComponentType type) {
        return this.registerBlock(classOf, itemClassOf, unlocalizedName, type, LCCreativeTabManager.getTab("LanteaCraft"));
    }

    public <T extends Block> T registerBlock(Class<? extends T> classOf, Class<? extends ItemBlock> itemClassOf, String unlocalizedName, ComponentType type, CreativeTabs tab) {
        LCLog.debug("Attempting to register block %s", unlocalizedName);
        try {
            Constructor<T> ctor = classOf.getConstructor(new Class[0]);
            Block theMysteryBlock = (Block)ctor.newInstance(new Object[0]);
            theMysteryBlock.func_149663_c(unlocalizedName);
            theMysteryBlock.func_149647_a(tab);
            if (theMysteryBlock instanceof IConfigure) {
                ((IConfigure)theMysteryBlock).configure(LCRuntime.runtime.config().config(type));
            }
            GameRegistry.registerBlock((Block)theMysteryBlock, itemClassOf, (String)unlocalizedName);
            return (T)theMysteryBlock;
        }
        catch (Throwable e) {
            LCLog.fatal("Failed to register block, an exception occured.", e);
            throw new RuntimeException(e);
        }
    }

    public <T extends Item> T registerItem(Class<? extends T> classOf, String unlocalizedName, ComponentType type) {
        return this.registerItem(classOf, unlocalizedName, type, LCCreativeTabManager.getTab("LanteaCraft"));
    }

    public <T extends Item> T registerItem(Class<? extends T> classOf, String unlocalizedName, ComponentType type, CreativeTabs tab) {
        LCLog.debug("Attempting to register item " + unlocalizedName);
        try {
            Constructor<T> ctor = classOf.getConstructor(new Class[0]);
            Item theMysteryItem = (Item)ctor.newInstance(new Object[0]);
            theMysteryItem.func_77655_b(unlocalizedName).func_77637_a(tab);
            if (theMysteryItem instanceof IConfigure) {
                ((IConfigure)theMysteryItem).configure(LCRuntime.runtime.config().config(type));
            }
            GameRegistry.registerItem((Item)theMysteryItem, (String)unlocalizedName);
            return (T)theMysteryItem;
        }
        catch (Exception e) {
            LCLog.fatal("Failed to register item, an exception occured.", e);
            throw new RuntimeException(e);
        }
    }

    public LCItemBucket registerSpecialBucket(LCBlock hostOf, String unlocalizedName, String bucketTextureName, CreativeTabs tab) {
        LCLog.debug("Attempting to register SpecialBucket " + unlocalizedName);
        LCItemBucket bucket = new LCItemBucket(hostOf);
        bucket.func_77655_b(unlocalizedName).func_77637_a(tab);
        bucket.setTargetTexture(bucketTextureName);
        GameRegistry.registerItem((Item)bucket, (String)unlocalizedName);
        return bucket;
    }

    public void registerTileEntity(Class<? extends LCTile> tileType, String tileName) {
        GameRegistry.registerTileEntity(tileType, (String)tileName);
    }

    public void registerBlockRenderer(Class<? extends LCBlock> block, Class<? extends LCBlockRenderer> renderer) {
        if (!this.registeredRenderers.containsKey((Object)RendererType.BLOCK)) {
            this.registeredRenderers.put(RendererType.BLOCK, new HashMap());
        }
        this.registeredRenderers.get((Object)RendererType.BLOCK).put(block, renderer);
    }

    public void registerTileRenderer(Class<? extends LCTile> tile, Class<? extends LCTileRenderer> renderer) {
        if (!this.registeredRenderers.containsKey((Object)RendererType.TILE)) {
            this.registeredRenderers.put(RendererType.TILE, new HashMap());
        }
        this.registeredRenderers.get((Object)RendererType.TILE).put(tile, renderer);
    }

    public void registerItemRenderer(Class<? extends LCItem> item, Class<? extends LCItemRenderer> renderer) {
        if (!this.registeredRenderers.containsKey((Object)RendererType.ITEM)) {
            this.registeredRenderers.put(RendererType.ITEM, new HashMap());
        }
        this.registeredRenderers.get((Object)RendererType.ITEM).put(item, renderer);
    }

    public void registerEntityRenderer(Class<? extends Entity> entity, Class<? extends LCEntityRenderer> renderer) {
        if (!this.registeredRenderers.containsKey((Object)RendererType.ENTITY)) {
            this.registeredRenderers.put(RendererType.ENTITY, new HashMap());
        }
        this.registeredRenderers.get((Object)RendererType.ENTITY).put(entity, renderer);
    }

    public ILanteaCraftRenderer getRendererFor(RendererType typeof, Class<?> clazz) {
        if (this.initializedRenderers.containsKey((Object)typeof)) {
            for (Map.Entry<Class<?>, ILanteaCraftRenderer> renderer : this.initializedRenderers.get((Object)typeof).entrySet()) {
                if (!renderer.getKey().equals(clazz)) continue;
                return renderer.getValue();
            }
        }
        if (!this.registeredRenderers.containsKey((Object)typeof)) {
            return null;
        }
        Map<Class<?>, Class<ILanteaCraftRenderer>> typemap = this.registeredRenderers.get((Object)typeof);
        for (Map.Entry<Class<?>, Class<ILanteaCraftRenderer>> type : typemap.entrySet()) {
            if (!type.getKey().equals(clazz)) continue;
            try {
                ILanteaCraftRenderer renderer = type.getValue().getConstructor(new Class[0]).newInstance(new Object[0]);
                if (renderer instanceof IConfigure) {
                    ((IConfigure)((Object)renderer)).configure(LCRuntime.runtime.config().config(ComponentType.CLIENT));
                }
                if (!this.initializedRenderers.containsKey((Object)typeof)) {
                    this.initializedRenderers.put(typeof, new HashMap());
                }
                this.initializedRenderers.get((Object)typeof).put(clazz, renderer);
                LCLog.trace(new Object[]{"Successfully initialized renderer %s (type: %s)", type.getValue().getName(), typeof});
                return renderer;
            }
            catch (Throwable t) {
                LCLog.warn("Failed to initialize renderer.", t);
                return null;
            }
        }
        return null;
    }

    public ILanteaCraftRenderer getRenderer(RendererType typeof, Class<? extends ILanteaCraftRenderer> type) {
        if (this.initializedRenderers.containsKey((Object)typeof)) {
            for (Map.Entry<Class<?>, ILanteaCraftRenderer> renderer : this.initializedRenderers.get((Object)typeof).entrySet()) {
                if (!renderer.getValue().getClass().equals(type)) continue;
                return renderer.getValue();
            }
        }
        return null;
    }

    public static enum RendererType {
        BLOCK,
        ENTITY,
        TILE,
        ITEM;

    }
}

