/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import java.util.ArrayList;
import lc.api.defs.IDefinitionReference;
import lc.api.defs.IGameDef;

public class DefinitionReference
implements IDefinitionReference {
    private final IGameDef def;
    private final ArrayList<Object> params;

    public DefinitionReference(IGameDef def) {
        if (def == null) {
            throw new RuntimeException("Cannot create a null definition reference.");
        }
        this.def = def;
        this.params = new ArrayList();
    }

    public DefinitionReference(IGameDef def, Object ... params) {
        this(def);
        for (Object o : params) {
            this.params.add(o);
        }
    }

    @Override
    public IGameDef reference() {
        return this.def;
    }

    @Override
    public Object[] parameters() {
        return this.params == null || this.params.size() == 0 ? null : this.params.toArray();
    }

    @Override
    public DefinitionReference push(int i, Object v) {
        this.params.set(i, v);
        return this;
    }

    @Override
    public DefinitionReference pushAll(Object ... paramList) {
        this.params.clear();
        for (Object obj : paramList) {
            this.params.add(obj);
        }
        return this;
    }

    @Override
    public DefinitionReference copy() {
        if (this.params != null && this.params.size() > 0) {
            return new DefinitionReference(this.def, this.parameters());
        }
        return new DefinitionReference(this.def);
    }
}

