/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.registry;

import lc.LCRuntime;
import lc.api.components.ComponentType;
import lc.api.defs.IContainerDefinition;
import lc.api.defs.IDefinitionReference;
import lc.common.base.LCBlock;
import lc.common.base.LCItem;
import lc.common.base.LCItemBlock;
import lc.common.base.LCTile;
import lc.common.impl.registry.DefinitionReference;
import lc.common.impl.registry.DefinitionRegistry;
import lc.common.util.Tracer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class BlockItemDefinition
implements IContainerDefinition {
    private final ComponentType ownerType;
    private final String defName;
    private final Class<? extends LCBlock> blockType;
    private LCBlock blockObject;
    private final Class<? extends LCItem> itemType;
    private Item itemObject;
    private final Class<? extends LCItemBlock> itemBlockType;
    private ItemBlock itemBlockObject;
    private Class<? extends LCTile> tileType;

    public BlockItemDefinition(ComponentType ownerType, String defName, Class<? extends LCBlock> blockType, Class<? extends Item> itemType) {
        this.ownerType = ownerType;
        this.defName = defName;
        if (LCItemBlock.class.isAssignableFrom(itemType)) {
            this.itemType = null;
            this.itemBlockType = itemType;
        } else {
            this.itemType = itemType;
            this.itemBlockType = null;
        }
        this.blockType = blockType;
    }

    public BlockItemDefinition setTileType(Class<? extends LCTile> type) {
        this.tileType = type;
        return this;
    }

    public ComponentType getComponentOwner() {
        return this.ownerType;
    }

    public void init(DefinitionRegistry registry) {
        if (!LCRuntime.runtime.registries().components().isEnabled(this.ownerType)) {
            return;
        }
        Tracer.begin(this);
        if (this.blockType != null && this.itemBlockType != null) {
            this.blockObject = registry.registerBlock(this.blockType, this.itemBlockType, this.defName, this.ownerType);
            this.blockObject.setProvidesTile(this.tileType);
            if (this.tileType != null) {
                String tileName = this.tileType.getSimpleName();
                if (tileName.startsWith("Tile")) {
                    tileName.replace("Tile", "tileEntity");
                }
                registry.registerTileEntity(this.tileType, tileName);
            }
        } else if (this.itemType != null) {
            this.itemObject = registry.registerItem(this.itemType, this.defName, this.ownerType);
        }
        LCRuntime.runtime.hints().provideHints(this);
        Tracer.end();
    }

    @Override
    public String getName() {
        return this.defName;
    }

    @Override
    public Block getBlock() {
        return this.blockObject;
    }

    @Override
    public Item getItem() {
        return this.itemBlockType != null ? this.itemBlockObject : this.itemObject;
    }

    @Override
    public Class<? extends TileEntity> getTileType() {
        return this.tileType;
    }

    @Override
    public Class<? extends Entity> getEntityType() {
        return null;
    }

    @Override
    public ItemStack getStackOf(int size) {
        return this.itemBlockType != null ? new ItemStack((Block)this.blockObject, size) : new ItemStack(this.itemObject, size);
    }

    @Override
    public IDefinitionReference ref() {
        return new DefinitionReference(this);
    }
}

