/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.drivers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import lc.LanteaCraft;
import lc.api.jit.ASMTag;
import lc.api.jit.Tag;
import lc.common.LCLog;
import lc.common.impl.drivers.ComputerMethodExecutor;
import lc.common.impl.drivers.IComputerTypeCaster;
import lc.common.impl.drivers.OpenComputersDriverManager;
import lc.common.resource.ResourceAccess;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class OpenComputersEnvironmentDriver
implements OpenComputersDriverManager.IOCManagedEnvPerp {
    private String[] opencomputers_methodcache;
    private Node opencomputers_node;
    private Node opencomputers_fs;

    private void opencomputers_assertReady() {
        if (this.opencomputers_node == null) {
            this.opencomputers_node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).create();
            this.opencomputers_fs = (Node)li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(LanteaCraft.class, (String)ResourceAccess.getAssetKey(), (String)"support/opencomputers/software"), (String)"lanteacraft");
        }
    }

    public Node node() {
        this.opencomputers_assertReady();
        return this.opencomputers_node;
    }

    public void load(NBTTagCompound nbt) {
        this.opencomputers_assertReady();
        if (this.opencomputers_node != null) {
            this.opencomputers_node.load(nbt.func_74775_l("node"));
        }
    }

    public void save(NBTTagCompound nbt) {
        this.opencomputers_assertReady();
        if (this.opencomputers_node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            this.opencomputers_node.save(nodeTag);
            nbt.func_74782_a("node", (NBTBase)nodeTag);
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void onConnect(Node node) {
        this.opencomputers_assertReady();
        if (node.host() instanceof Context) {
            node.connect(this.opencomputers_fs);
        }
    }

    public void onDisconnect(Node node) {
        this.opencomputers_assertReady();
        if (node.host() instanceof Context) {
            node.disconnect(this.opencomputers_fs);
        } else if (node == this.opencomputers_node) {
            this.opencomputers_fs.remove();
        }
    }

    public void onMessage(Message message) {
        this.opencomputers_assertReady();
    }

    public void update() {
    }

    @Override
    public String getComponentName() {
        return OpenComputersDriverManager.findComponentName(this.getClass().getSimpleName());
    }

    public String[] methods() {
        if (this.opencomputers_methodcache == null) {
            Method[] methods;
            ArrayList<String> alist = new ArrayList<String>();
            Class<?> zz = this.getClass();
            for (Method m : methods = zz.getMethods()) {
                LCLog.debug("OpenComputers driver: assessing method %s (class %s).", m.getName(), zz.getSimpleName());
                Tag foundTag = ASMTag.findTag(this.getClass(), m, "ComputerCallable");
                if (foundTag == null) continue;
                LCLog.debug("OpenComputers driver: adding method %s", m.getName());
                alist.add(m.getName());
            }
            this.opencomputers_methodcache = alist.toArray(new String[0]);
        }
        return this.opencomputers_methodcache == null ? new String[]{} : this.opencomputers_methodcache;
    }

    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        try {
            Object[] aargs = new Object[args.count()];
            for (int i = 0; i < aargs.length; ++i) {
                aargs[i] = args.checkAny(i);
            }
            Object aresult = ComputerMethodExecutor.executor().invokeMethod(this.getClass(), this, IComputerTypeCaster.typeCastOC, method, aargs);
            return new Object[]{aresult};
        }
        catch (Exception exception) {
            LCLog.warn("Problem calling method from OpenComputer driver!", exception);
            throw new Exception(exception.getMessage());
        }
    }
}

