/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.drivers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import lc.api.components.IntegrationType;
import lc.api.jit.ASMTag;
import lc.api.jit.DeviceDrivers;
import lc.api.jit.Tag;
import lc.common.LCLog;
import lc.digital.vm.IDeviceAccess;
import lc.digital.vm.peripheral.ILCPeripheral;

@DeviceDrivers.DriverProvider(type=IntegrationType.COMPUTERS)
public class LanteaCraftPeripheralDriver
implements ILCPeripheral {
    private String[] lcpd_methodcache;
    private ArrayList<IDeviceAccess> lcpd_devices;

    private void lcpd_assertReady() {
        if (this.lcpd_devices == null) {
            this.lcpd_devices = new ArrayList();
        }
    }

    @DeviceDrivers.DriverRTCallback(event="computerEvent")
    public void lcpd_handleEvent(String event, Object ... args) {
        this.lcpd_assertReady();
        for (IDeviceAccess network : this.lcpd_devices) {
            network.signal(this, event, args);
        }
    }

    @Override
    public String getLCPType() {
        return this.getClass().getSimpleName().replace("Tile", "").replace("tile", "");
    }

    @Override
    public String[] getLCPMethods() {
        if (this.lcpd_methodcache == null) {
            Method[] methods;
            ArrayList<String> alist = new ArrayList<String>();
            Class<?> zz = this.getClass();
            for (Method m : methods = zz.getMethods()) {
                LCLog.debug("LanteaCraft driver: assessing method %s (class %s).", m.getName(), zz.getSimpleName());
                Tag foundTag = ASMTag.findTag(this.getClass(), m, "ComputerCallable");
                if (foundTag == null) continue;
                LCLog.debug("LanteaCraft driver: adding method %s", m.getName());
                alist.add(m.getName());
            }
            this.lcpd_methodcache = alist.toArray(new String[0]);
        }
        return this.lcpd_methodcache == null ? new String[]{} : this.lcpd_methodcache;
    }

    @Override
    public Object invokeLCPMethod(String label, Object[] arguments) throws Exception {
        Method foundMethod = null;
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().equals(label)) continue;
            foundMethod = m;
        }
        if (foundMethod == null) {
            throw new Exception("No such method.");
        }
        try {
            Class<?>[] types = foundMethod.getParameterTypes();
            if (arguments.length != types.length) {
                throw new Exception("Incorrect number of parameters.");
            }
            return foundMethod.invoke((Object)this, arguments);
        }
        catch (Exception exception) {
            LCLog.warn("Problem calling method from LC proxy driver!", exception);
            throw new Exception(exception.getMessage());
        }
    }

    @Override
    public void onLCPConnect(IDeviceAccess network) {
        this.lcpd_assertReady();
        this.lcpd_devices.add(network);
    }

    @Override
    public void onLCPDisconnect(IDeviceAccess network) {
        this.lcpd_assertReady();
        this.lcpd_devices.remove(network);
    }
}

