/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.drivers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import lc.api.jit.ASMTag;
import lc.api.jit.Tag;
import lc.common.LCLog;
import lc.common.impl.drivers.IComputerTypeCaster;

public class ComputerMethodExecutor {
    private static ComputerMethodExecutor executor = new ComputerMethodExecutor();
    private HashMap<String, ArrayList<String>> nametable = new HashMap();

    public static ComputerMethodExecutor executor() {
        return executor;
    }

    private ComputerMethodExecutor() {
    }

    private ArrayList<String> cacheMethods(Class<?> klass) {
        Method[] methods;
        ArrayList<String> alist = new ArrayList<String>();
        for (Method m : methods = klass.getMethods()) {
            Tag foundTag = ASMTag.findTag(this.getClass(), m, "ComputerCallable");
            if (foundTag == null) continue;
            LCLog.debug("ComputerMethodExecutor: Caching method %s %s", klass.getName(), m.getName());
            alist.add(m.getName());
        }
        this.nametable.put(klass.getName(), alist);
        return alist;
    }

    public String[] getMethods(Class<?> klass) {
        ArrayList<String> table = this.nametable.get(klass.getName());
        if (table == null) {
            return this.cacheMethods(klass).toArray(new String[0]);
        }
        return table.toArray(new String[0]);
    }

    public Object invokeMethod(Class<?> klass, Object cle, IComputerTypeCaster tcs, String method, Object[] varargs) throws Exception {
        Method[] methods;
        ArrayList<String> table = this.nametable.get(klass.getName());
        if (table == null) {
            table = this.cacheMethods(klass);
        }
        if (!table.contains(method)) {
            throw new Exception("No such method.");
        }
        Method m0 = null;
        for (Method m : methods = klass.getMethods()) {
            Tag foundTag = ASMTag.findTag(this.getClass(), m, "ComputerCallable");
            if (foundTag == null || !m.getName().equals(method)) continue;
            m0 = m;
        }
        if (m0 == null) {
            throw new Exception("No such method.");
        }
        try {
            Class<?>[] types = m0.getParameterTypes();
            if (varargs.length != types.length) {
                throw new Exception("Incorrect number of parameters.");
            }
            Object[] aargs = new Object[varargs.length];
            for (int i = 0; i < aargs.length; ++i) {
                aargs[i] = tcs.performCastToType(varargs[i], types[i]);
            }
            Object aresult = m0.invoke(cle, aargs);
            Object vrt = tcs.castToComputerSafe(aresult);
            return vrt;
        }
        catch (Exception exception) {
            LCLog.warn("Problem calling method from ComputerMethodExecutor!", exception);
            throw new Exception(exception.getMessage());
        }
    }
}

