/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.drivers;

import dan200.computercraft.api.filesystem.IMount;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import lc.LanteaCraft;
import lc.common.LCLog;

public class ComputerCraftScuffMount
implements IMount {
    private File mountFile;
    private File mountFolder;
    private String mountSubFile;
    private ZipFile mountDataArchive;
    private ScuffMappedFile index;

    public static ComputerCraftScuffMount generateMount() {
        String path = LanteaCraft.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.indexOf("!") >= 0) {
            path = path.substring(0, path.indexOf("!"));
        }
        if (path.endsWith(".class")) {
            path = path.replace("lc/LanteaCraft.class", "");
            path = path.replace("lc\\LanteaCraft.class", "");
        }
        if (path.startsWith("file")) {
            path = path.replace("file:\\", "");
            path = path.replace("file:/", "");
        }
        LCLog.debug("Working path: %s", path);
        return new ComputerCraftScuffMount(new File(path), "assets/pcl_lc/drivers/support/computercraft");
    }

    public ComputerCraftScuffMount(File file, String target) {
        if (file.isDirectory()) {
            this.mountFolder = new File(file, target);
        } else {
            this.mountFile = file;
            this.mountSubFile = target;
        }
    }

    public void init() throws ZipException, IOException {
        if (!this.isFilesystemMount()) {
            this.mountDataArchive = new ZipFile(this.mountFile);
        }
        this.prepareDataIndex();
        if (!this.index.isDirectory()) {
            LCLog.warn("Failed to generate directory");
        }
        if (this.index.subfiles.isEmpty()) {
            LCLog.warn("Didn't index any files");
        }
    }

    public void shutdown() {
        try {
            if (this.mountDataArchive != null) {
                this.mountDataArchive.close();
            }
        }
        catch (IOException ioex) {
            LCLog.debug("Problem shutting down virtual filesystem.", ioex);
        }
        finally {
            this.mountDataArchive = null;
        }
    }

    public boolean isFilesystemMount() {
        return this.mountFolder != null;
    }

    private void prepareDataIndex() throws IOException {
        this.index = new ScuffMappedFile("/");
        if (this.isFilesystemMount()) {
            this.buildFileIndexInto(this.mountFolder, this.index);
        } else {
            ZipEntry top = this.mountDataArchive.getEntry(this.mountSubFile);
            if (top == null) {
                throw new IOException("Unknown target folder " + this.mountSubFile);
            }
            this.buildFileIndexInto(this.mountDataArchive, this.mountSubFile, this.index);
        }
    }

    private void buildFileIndexInto(File directory, ScuffMappedFile map) {
        File[] subfiles;
        for (File subfile : subfiles = directory.listFiles()) {
            if (subfile.isDirectory()) {
                ScuffMappedFile dirMap = new ScuffMappedFile(subfile.getName());
                this.buildFileIndexInto(subfile, dirMap);
                map.file(dirMap);
                continue;
            }
            map.file(new ScuffMappedFile(subfile.getName()));
        }
    }

    private void buildFileIndexInto(ZipFile file, String topPath, ScuffMappedFile map) {
        Enumeration<? extends ZipEntry> iter = file.entries();
        while (iter.hasMoreElements()) {
            ZipEntry entry = iter.nextElement();
            String objectName = entry.getName();
            if (!objectName.startsWith(this.mountSubFile)) continue;
            objectName = objectName.substring(this.mountSubFile.length());
            String[] route = this.pathToScuff(objectName);
            ScuffMappedFile obj = this.index;
            for (int i = 0; i < route.length; ++i) {
                ScuffMappedFile obj0 = obj.file(route[i]);
                if (obj0 == null) {
                    obj0 = new ScuffMappedFile(route[i]);
                    obj.file(obj0);
                }
                obj = obj0;
            }
        }
    }

    private String[] pathToScuff(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] bits = path.trim().split("/");
        ArrayList<String> result = new ArrayList<String>();
        for (String bit : bits) {
            if (bit.length() == 0) continue;
            result.add(bit);
        }
        return result.toArray(new String[0]);
    }

    private ScuffMappedFile fileForPath(String path) {
        String[] route = this.pathToScuff(path);
        ScuffMappedFile obj = this.index;
        for (int i = 0; i < route.length; ++i) {
            if ((obj = obj.file(route[i])) != null) continue;
            return null;
        }
        return obj;
    }

    private String getStringForFile(ScuffMappedFile file) {
        Stack<String> stack = new Stack<String>();
        ScuffMappedFile file0 = file;
        while (file0 != null) {
            stack.push(file0.filename);
            file0 = file0.parent;
            if (file0 != this.index) continue;
        }
        if (file0 == null) {
            throw new RuntimeException("Expected to arrive at index but did not.");
        }
        StringBuilder blob = new StringBuilder();
        while (!stack.isEmpty()) {
            blob.append("/").append((String)stack.pop());
        }
        return blob.toString();
    }

    public boolean exists(String path) throws IOException {
        return this.fileForPath(path) != null;
    }

    public boolean isDirectory(String path) throws IOException {
        ScuffMappedFile file = this.fileForPath(path);
        if (file == null) {
            return false;
        }
        return file.isDirectory();
    }

    public void list(String path, List<String> contents) throws IOException {
        ScuffMappedFile file = this.fileForPath(path);
        if (file == null || file.subfiles == null) {
            return;
        }
        for (String filename : file.subfiles.keySet()) {
            contents.add(filename);
        }
    }

    public long getSize(String path) throws IOException {
        ScuffMappedFile file = this.fileForPath(path);
        if (file == null) {
            return 0L;
        }
        String realpath = this.getStringForFile(file);
        if (this.isFilesystemMount()) {
            File f0 = new File(this.mountFolder, realpath);
            if (f0.isDirectory()) {
                return 0L;
            }
            return f0.length();
        }
        ZipEntry f0 = this.mountDataArchive.getEntry(this.mountSubFile + realpath);
        if (f0.isDirectory()) {
            return 0L;
        }
        return f0.getSize();
    }

    public InputStream openForRead(String path) throws IOException {
        ScuffMappedFile file = this.fileForPath(path);
        if (file == null || file.isDirectory()) {
            throw new IOException("No such file");
        }
        String realpath = this.getStringForFile(file);
        if (this.isFilesystemMount()) {
            File f0 = new File(this.mountFolder, realpath);
            return new FileInputStream(f0);
        }
        ZipEntry f0 = this.mountDataArchive.getEntry(this.mountSubFile + realpath);
        return this.mountDataArchive.getInputStream(f0);
    }

    private class ScuffMappedFile {
        public ScuffMappedFile parent;
        public String filename;
        public HashMap<String, ScuffMappedFile> subfiles;

        public ScuffMappedFile(String filename) {
            this.filename = filename;
        }

        public boolean isDirectory() {
            return this.subfiles != null;
        }

        public void file(ScuffMappedFile file) {
            if (this.subfiles == null) {
                this.subfiles = new HashMap();
            }
            file.parent = this;
            this.subfiles.put(file.filename, file);
        }

        public ScuffMappedFile file(String name) {
            if (this.subfiles == null) {
                return null;
            }
            return this.subfiles.get(name);
        }
    }
}

