/*
 * Decompiled with CFR 0.152.
 */
package lc.common.impl.drivers;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import lc.api.components.IntegrationType;
import lc.api.jit.ASMTag;
import lc.api.jit.DeviceDrivers;
import lc.api.jit.Tag;
import lc.common.LCLog;
import lc.common.impl.drivers.ComputerCraftScuffMount;
import lc.common.impl.drivers.ComputerMethodExecutor;
import lc.common.impl.drivers.IComputerTypeCaster;
import net.minecraft.tileentity.TileEntity;

@DeviceDrivers.DriverProvider(type=IntegrationType.COMPUTERS)
public class ComputerCraftPeripheralDriver
implements IPeripheral {
    private String[] computercraft_methodcache;
    private ArrayList<IComputerAccess> computercraft_icalist;
    private HashMap<IComputerAccess, ComputerCraftScuffMount> computercraft_mounts;

    private void computercraft_assertReady() {
        if (this.computercraft_icalist == null) {
            this.computercraft_icalist = new ArrayList();
            this.computercraft_mounts = new HashMap();
        }
    }

    @DeviceDrivers.DriverRTCallback(event="isSideSolid")
    public void computerCraft_checkIsSideSolid(Object[] args) {
        String[] klasses;
        for (String klass : klasses = (String[])args[1]) {
            if (!klass.startsWith("dan200")) continue;
            args[0] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeviceDrivers.DriverRTCallback(event="computerEvent")
    public void computerCraft_handleEvent(String event, Object ... args) {
        this.computercraft_assertReady();
        ArrayList<IComputerAccess> arrayList = this.computercraft_icalist;
        synchronized (arrayList) {
            for (IComputerAccess azz : this.computercraft_icalist) {
                azz.queueEvent(event, args);
            }
        }
    }

    public String getType() {
        return this.getClass().getSimpleName().replace("Tile", "").replace("tile", "");
    }

    public String[] getMethodNames() {
        if (this.computercraft_methodcache == null) {
            Method[] methods;
            ArrayList<String> alist = new ArrayList<String>();
            Class<?> zz = this.getClass();
            for (Method m : methods = zz.getMethods()) {
                LCLog.debug("ComputerCraft driver: assessing method %s (class %s).", m.getName(), zz.getSimpleName());
                Tag foundTag = ASMTag.findTag(this.getClass(), m, "ComputerCallable");
                if (foundTag == null) continue;
                LCLog.debug("ComputerCraft driver: adding method %s", m.getName());
                alist.add(m.getName());
            }
            this.computercraft_methodcache = alist.toArray(new String[0]);
        }
        return this.computercraft_methodcache == null ? new String[]{} : this.computercraft_methodcache;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        String[] methods = ComputerMethodExecutor.executor().getMethods(this.getClass());
        if (method < 0 || method >= methods.length) {
            LCLog.warn("ComputerCraft driver: callMethod requesting method %s but only have %s methods!", method, methods.length);
            throw new LuaException("Error invoking.");
        }
        String label = methods[method];
        try {
            Object aresult = ComputerMethodExecutor.executor().invokeMethod(this.getClass(), this, IComputerTypeCaster.typeCastCC, label, arguments);
            return new Object[]{aresult};
        }
        catch (Exception exception) {
            LCLog.warn("Problem calling method from ComputerCraft driver!", exception);
            throw new LuaException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(IComputerAccess computer) {
        this.computercraft_assertReady();
        ArrayList<IComputerAccess> arrayList = this.computercraft_icalist;
        synchronized (arrayList) {
            this.computercraft_icalist.add(computer);
        }
        try {
            ComputerCraftScuffMount mount = ComputerCraftScuffMount.generateMount();
            mount.init();
            this.computercraft_mounts.put(computer, mount);
            computer.mount("/lanteacraft", (IMount)mount);
        }
        catch (Exception ex) {
            LCLog.fatal("Unable to generate Computer mount.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(IComputerAccess computer) {
        this.computercraft_assertReady();
        ArrayList<IComputerAccess> arrayList = this.computercraft_icalist;
        synchronized (arrayList) {
            this.computercraft_icalist.remove(computer);
        }
        try {
            computer.unmount("/lanteacraft");
            ComputerCraftScuffMount mount = this.computercraft_mounts.get(computer);
            if (mount != null) {
                mount.shutdown();
            }
        }
        catch (Exception ex) {
            LCLog.fatal("Unable to garbage collect Computer mount.", ex);
        }
    }

    public boolean equals(IPeripheral other) {
        if (TileEntity.class.isAssignableFrom(this.getClass()) && other instanceof TileEntity) {
            TileEntity me = (TileEntity)TileEntity.class.cast(this);
            TileEntity them = (TileEntity)other;
            if (!me.func_145831_w().equals(them.func_145831_w())) {
                return false;
            }
            return me.field_145851_c == them.field_145851_c && me.field_145848_d == them.field_145848_d && me.field_145849_e == them.field_145849_e;
        }
        return false;
    }
}

